package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNodeOnBaseline invokes the dataworks_public.GetNodeOnBaseline API synchronously
func (client *Client) GetNodeOnBaseline(request *GetNodeOnBaselineRequest) (response *GetNodeOnBaselineResponse, err error) {
	response = CreateGetNodeOnBaselineResponse()
	err = client.DoAction(request, response)
	return
}

// GetNodeOnBaselineWithChan invokes the dataworks_public.GetNodeOnBaseline API asynchronously
func (client *Client) GetNodeOnBaselineWithChan(request *GetNodeOnBaselineRequest) (<-chan *GetNodeOnBaselineResponse, <-chan error) {
	responseChan := make(chan *GetNodeOnBaselineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNodeOnBaseline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNodeOnBaselineWithCallback invokes the dataworks_public.GetNodeOnBaseline API asynchronously
func (client *Client) GetNodeOnBaselineWithCallback(request *GetNodeOnBaselineRequest, callback func(response *GetNodeOnBaselineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNodeOnBaselineResponse
		var err error
		defer close(result)
		response, err = client.GetNodeOnBaseline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNodeOnBaselineRequest is the request struct for api GetNodeOnBaseline
type GetNodeOnBaselineRequest struct {
	*requests.RpcRequest
	BaselineId requests.Integer `position:"Body" name:"BaselineId"`
}

// GetNodeOnBaselineResponse is the response struct for api GetNodeOnBaseline
type GetNodeOnBaselineResponse struct {
	*responses.BaseResponse
	Success        string     `json:"Success" xml:"Success"`
	ErrorCode      string     `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string     `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Data           []DataItem `json:"Data" xml:"Data"`
}

// CreateGetNodeOnBaselineRequest creates a request to invoke GetNodeOnBaseline API
func CreateGetNodeOnBaselineRequest() (request *GetNodeOnBaselineRequest) {
	request = &GetNodeOnBaselineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetNodeOnBaseline", "", "")
	request.Method = requests.POST
	return
}

// CreateGetNodeOnBaselineResponse creates a response to parse from GetNodeOnBaseline response
func CreateGetNodeOnBaselineResponse() (response *GetNodeOnBaselineResponse) {
	response = &GetNodeOnBaselineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
