package dbfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddTagsBatch invokes the dbfs.AddTagsBatch API synchronously
func (client *Client) AddTagsBatch(request *AddTagsBatchRequest) (response *AddTagsBatchResponse, err error) {
	response = CreateAddTagsBatchResponse()
	err = client.DoAction(request, response)
	return
}

// AddTagsBatchWithChan invokes the dbfs.AddTagsBatch API asynchronously
func (client *Client) AddTagsBatchWithChan(request *AddTagsBatchRequest) (<-chan *AddTagsBatchResponse, <-chan error) {
	responseChan := make(chan *AddTagsBatchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddTagsBatch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddTagsBatchWithCallback invokes the dbfs.AddTagsBatch API asynchronously
func (client *Client) AddTagsBatchWithCallback(request *AddTagsBatchRequest, callback func(response *AddTagsBatchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddTagsBatchResponse
		var err error
		defer close(result)
		response, err = client.AddTagsBatch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddTagsBatchRequest is the request struct for api AddTagsBatch
type AddTagsBatchRequest struct {
	*requests.RpcRequest
	DbfsList    string `position:"Query" name:"DbfsList"`
	ClientToken string `position:"Query" name:"ClientToken"`
	Tags        string `position:"Query" name:"Tags"`
}

// AddTagsBatchResponse is the response struct for api AddTagsBatch
type AddTagsBatchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddTagsBatchRequest creates a request to invoke AddTagsBatch API
func CreateAddTagsBatchRequest() (request *AddTagsBatchRequest) {
	request = &AddTagsBatchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DBFS", "2020-04-18", "AddTagsBatch", "", "")
	request.Method = requests.POST
	return
}

// CreateAddTagsBatchResponse creates a response to parse from AddTagsBatch response
func CreateAddTagsBatchResponse() (response *AddTagsBatchResponse) {
	response = &AddTagsBatchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
