package ddosbgp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePackIpList invokes the ddosbgp.DescribePackIpList API synchronously
// api document: https://help.aliyun.com/api/ddosbgp/describepackiplist.html
func (client *Client) DescribePackIpList(request *DescribePackIpListRequest) (response *DescribePackIpListResponse, err error) {
	response = CreateDescribePackIpListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePackIpListWithChan invokes the ddosbgp.DescribePackIpList API asynchronously
// api document: https://help.aliyun.com/api/ddosbgp/describepackiplist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePackIpListWithChan(request *DescribePackIpListRequest) (<-chan *DescribePackIpListResponse, <-chan error) {
	responseChan := make(chan *DescribePackIpListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePackIpList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePackIpListWithCallback invokes the ddosbgp.DescribePackIpList API asynchronously
// api document: https://help.aliyun.com/api/ddosbgp/describepackiplist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePackIpListWithCallback(request *DescribePackIpListRequest, callback func(response *DescribePackIpListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePackIpListResponse
		var err error
		defer close(result)
		response, err = client.DescribePackIpList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePackIpListRequest is the request struct for api DescribePackIpList
type DescribePackIpListRequest struct {
	*requests.RpcRequest
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	DdosRegionId    string           `position:"Query" name:"DdosRegionId"`
	ProductName     string           `position:"Query" name:"ProductName"`
	Ip              string           `position:"Query" name:"Ip"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	PageNo          requests.Integer `position:"Query" name:"PageNo"`
}

// DescribePackIpListResponse is the response struct for api DescribePackIpList
type DescribePackIpListResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Success   bool     `json:"Success" xml:"Success"`
	Code      string   `json:"Code" xml:"Code"`
	Total     int      `json:"Total" xml:"Total"`
	IpList    []Ipitem `json:"IpList" xml:"IpList"`
}

// CreateDescribePackIpListRequest creates a request to invoke DescribePackIpList API
func CreateDescribePackIpListRequest() (request *DescribePackIpListRequest) {
	request = &DescribePackIpListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddosbgp", "2018-07-20", "DescribePackIpList", "ddosbgp", "openAPI")
	return
}

// CreateDescribePackIpListResponse creates a response to parse from DescribePackIpList response
func CreateDescribePackIpListResponse() (response *DescribePackIpListResponse) {
	response = &DescribePackIpListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
