package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSparkJobExecutorLogs invokes the dms_enterprise.GetSparkJobExecutorLogs API synchronously
func (client *Client) GetSparkJobExecutorLogs(request *GetSparkJobExecutorLogsRequest) (response *GetSparkJobExecutorLogsResponse, err error) {
	response = CreateGetSparkJobExecutorLogsResponse()
	err = client.DoAction(request, response)
	return
}

// GetSparkJobExecutorLogsWithChan invokes the dms_enterprise.GetSparkJobExecutorLogs API asynchronously
func (client *Client) GetSparkJobExecutorLogsWithChan(request *GetSparkJobExecutorLogsRequest) (<-chan *GetSparkJobExecutorLogsResponse, <-chan error) {
	responseChan := make(chan *GetSparkJobExecutorLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSparkJobExecutorLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSparkJobExecutorLogsWithCallback invokes the dms_enterprise.GetSparkJobExecutorLogs API asynchronously
func (client *Client) GetSparkJobExecutorLogsWithCallback(request *GetSparkJobExecutorLogsRequest, callback func(response *GetSparkJobExecutorLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSparkJobExecutorLogsResponse
		var err error
		defer close(result)
		response, err = client.GetSparkJobExecutorLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSparkJobExecutorLogsRequest is the request struct for api GetSparkJobExecutorLogs
type GetSparkJobExecutorLogsRequest struct {
	*requests.RpcRequest
	JobId requests.Integer `position:"Query" name:"JobId"`
	Tid   requests.Integer `position:"Query" name:"Tid"`
}

// GetSparkJobExecutorLogsResponse is the response struct for api GetSparkJobExecutorLogs
type GetSparkJobExecutorLogsResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Success      bool         `json:"Success" xml:"Success"`
	ErrorMessage string       `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string       `json:"ErrorCode" xml:"ErrorCode"`
	ExecutorLogs ExecutorLogs `json:"ExecutorLogs" xml:"ExecutorLogs"`
}

// CreateGetSparkJobExecutorLogsRequest creates a request to invoke GetSparkJobExecutorLogs API
func CreateGetSparkJobExecutorLogsRequest() (request *GetSparkJobExecutorLogsRequest) {
	request = &GetSparkJobExecutorLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetSparkJobExecutorLogs", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSparkJobExecutorLogsResponse creates a response to parse from GetSparkJobExecutorLogs response
func CreateGetSparkJobExecutorLogsResponse() (response *GetSparkJobExecutorLogsResponse) {
	response = &GetSparkJobExecutorLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
