package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ManagePrivateRds invokes the drds.ManagePrivateRds API synchronously
func (client *Client) ManagePrivateRds(request *ManagePrivateRdsRequest) (response *ManagePrivateRdsResponse, err error) {
	response = CreateManagePrivateRdsResponse()
	err = client.DoAction(request, response)
	return
}

// ManagePrivateRdsWithChan invokes the drds.ManagePrivateRds API asynchronously
func (client *Client) ManagePrivateRdsWithChan(request *ManagePrivateRdsRequest) (<-chan *ManagePrivateRdsResponse, <-chan error) {
	responseChan := make(chan *ManagePrivateRdsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ManagePrivateRds(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ManagePrivateRdsWithCallback invokes the drds.ManagePrivateRds API asynchronously
func (client *Client) ManagePrivateRdsWithCallback(request *ManagePrivateRdsRequest, callback func(response *ManagePrivateRdsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ManagePrivateRdsResponse
		var err error
		defer close(result)
		response, err = client.ManagePrivateRds(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ManagePrivateRdsRequest is the request struct for api ManagePrivateRds
type ManagePrivateRdsRequest struct {
	*requests.RpcRequest
	Params         string `position:"Query" name:"Params"`
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	DBInstanceId   string `position:"Query" name:"DBInstanceId"`
	RdsAction      string `position:"Query" name:"RdsAction"`
}

// ManagePrivateRdsResponse is the response struct for api ManagePrivateRds
type ManagePrivateRdsResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateManagePrivateRdsRequest creates a request to invoke ManagePrivateRds API
func CreateManagePrivateRdsRequest() (request *ManagePrivateRdsRequest) {
	request = &ManagePrivateRdsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "ManagePrivateRds", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateManagePrivateRdsResponse creates a response to parse from ManagePrivateRds response
func CreateManagePrivateRdsResponse() (response *ManagePrivateRdsResponse) {
	response = &ManagePrivateRdsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
