package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnlockSecretNo invokes the dyplsapi.UnlockSecretNo API synchronously
func (client *Client) UnlockSecretNo(request *UnlockSecretNoRequest) (response *UnlockSecretNoResponse, err error) {
	response = CreateUnlockSecretNoResponse()
	err = client.DoAction(request, response)
	return
}

// UnlockSecretNoWithChan invokes the dyplsapi.UnlockSecretNo API asynchronously
func (client *Client) UnlockSecretNoWithChan(request *UnlockSecretNoRequest) (<-chan *UnlockSecretNoResponse, <-chan error) {
	responseChan := make(chan *UnlockSecretNoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnlockSecretNo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnlockSecretNoWithCallback invokes the dyplsapi.UnlockSecretNo API asynchronously
func (client *Client) UnlockSecretNoWithCallback(request *UnlockSecretNoRequest, callback func(response *UnlockSecretNoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnlockSecretNoResponse
		var err error
		defer close(result)
		response, err = client.UnlockSecretNo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnlockSecretNoRequest is the request struct for api UnlockSecretNo
type UnlockSecretNoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
	SecretNo             string           `position:"Query" name:"SecretNo"`
}

// UnlockSecretNoResponse is the response struct for api UnlockSecretNo
type UnlockSecretNoResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnlockSecretNoRequest creates a request to invoke UnlockSecretNo API
func CreateUnlockSecretNoRequest() (request *UnlockSecretNoRequest) {
	request = &UnlockSecretNoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "UnlockSecretNo", "", "")
	request.Method = requests.POST
	return
}

// CreateUnlockSecretNoResponse creates a response to parse from UnlockSecretNo response
func CreateUnlockSecretNoResponse() (response *UnlockSecretNoResponse) {
	response = &UnlockSecretNoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
