//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package eci

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExecContainerCommand invokes the eci.ExecContainerCommand API synchronously
// api document: https://help.aliyun.com/api/eci/execcontainercommand.html
func (client *Client) ExecContainerCommand(request *ExecContainerCommandRequest) (response *ExecContainerCommandResponse, err error) {
	response = CreateExecContainerCommandResponse()
	err = client.DoAction(request, response)
	return
}

// ExecContainerCommandWithChan invokes the eci.ExecContainerCommand API asynchronously
// api document: https://help.aliyun.com/api/eci/execcontainercommand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExecContainerCommandWithChan(request *ExecContainerCommandRequest) (<-chan *ExecContainerCommandResponse, <-chan error) {
	responseChan := make(chan *ExecContainerCommandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExecContainerCommand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExecContainerCommandWithCallback invokes the eci.ExecContainerCommand API asynchronously
// api document: https://help.aliyun.com/api/eci/execcontainercommand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExecContainerCommandWithCallback(request *ExecContainerCommandRequest, callback func(response *ExecContainerCommandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExecContainerCommandResponse
		var err error
		defer close(result)
		response, err = client.ExecContainerCommand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExecContainerCommandRequest is the request struct for api ExecContainerCommand
type ExecContainerCommandRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	RegionId             string           `position:"Query" name:"RegionId"`
	ContainerGroupId     string           `position:"Query" name:"ContainerGroupId"`
	ContainerName        string           `position:"Query" name:"ContainerName"`
	Command              string           `position:"Query" name:"Command"`
	TTY                  requests.Boolean `position:"Query" name:"TTY"`
}

// ExecContainerCommandResponse is the response struct for api ExecContainerCommand
type ExecContainerCommandResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	WebSocketUri string `json:"WebSocketUri" xml:"WebSocketUri"`
}

// CreateExecContainerCommandRequest creates a request to invoke ExecContainerCommand API
func CreateExecContainerCommandRequest() (request *ExecContainerCommandRequest) {
	request = &ExecContainerCommandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Eci", "2018-08-08", "ExecContainerCommand", "eci", "openAPI")
	return
}

// CreateExecContainerCommandResponse creates a response to parse from ExecContainerCommand response
func CreateExecContainerCommandResponse() (response *ExecContainerCommandResponse) {
	response = &ExecContainerCommandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
