package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePrefixLists invokes the ecs.DescribePrefixLists API synchronously
func (client *Client) DescribePrefixLists(request *DescribePrefixListsRequest) (response *DescribePrefixListsResponse, err error) {
	response = CreateDescribePrefixListsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePrefixListsWithChan invokes the ecs.DescribePrefixLists API asynchronously
func (client *Client) DescribePrefixListsWithChan(request *DescribePrefixListsRequest) (<-chan *DescribePrefixListsResponse, <-chan error) {
	responseChan := make(chan *DescribePrefixListsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePrefixLists(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePrefixListsWithCallback invokes the ecs.DescribePrefixLists API asynchronously
func (client *Client) DescribePrefixListsWithCallback(request *DescribePrefixListsRequest, callback func(response *DescribePrefixListsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePrefixListsResponse
		var err error
		defer close(result)
		response, err = client.DescribePrefixLists(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePrefixListsRequest is the request struct for api DescribePrefixLists
type DescribePrefixListsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NextToken            string           `position:"Query" name:"NextToken"`
	PrefixListId         *[]string        `position:"Query" name:"PrefixListId"  type:"Repeated"`
	AddressFamily        string           `position:"Query" name:"AddressFamily"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PrefixListName       string           `position:"Query" name:"PrefixListName"`
	MaxResults           requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribePrefixListsResponse is the response struct for api DescribePrefixLists
type DescribePrefixListsResponse struct {
	*responses.BaseResponse
	NextToken   string      `json:"NextToken" xml:"NextToken"`
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	PrefixLists PrefixLists `json:"PrefixLists" xml:"PrefixLists"`
}

// CreateDescribePrefixListsRequest creates a request to invoke DescribePrefixLists API
func CreateDescribePrefixListsRequest() (request *DescribePrefixListsRequest) {
	request = &DescribePrefixListsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribePrefixLists", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePrefixListsResponse creates a response to parse from DescribePrefixLists response
func CreateDescribePrefixListsResponse() (response *DescribePrefixListsResponse) {
	response = &DescribePrefixListsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
