package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteServiceTimeConfig invokes the edas.DeleteServiceTimeConfig API synchronously
func (client *Client) DeleteServiceTimeConfig(request *DeleteServiceTimeConfigRequest) (response *DeleteServiceTimeConfigResponse, err error) {
	response = CreateDeleteServiceTimeConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteServiceTimeConfigWithChan invokes the edas.DeleteServiceTimeConfig API asynchronously
func (client *Client) DeleteServiceTimeConfigWithChan(request *DeleteServiceTimeConfigRequest) (<-chan *DeleteServiceTimeConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteServiceTimeConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteServiceTimeConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteServiceTimeConfigWithCallback invokes the edas.DeleteServiceTimeConfig API asynchronously
func (client *Client) DeleteServiceTimeConfigWithCallback(request *DeleteServiceTimeConfigRequest, callback func(response *DeleteServiceTimeConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteServiceTimeConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteServiceTimeConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteServiceTimeConfigRequest is the request struct for api DeleteServiceTimeConfig
type DeleteServiceTimeConfigRequest struct {
	*requests.RoaRequest
	Id string `position:"Query" name:"Id"`
}

// DeleteServiceTimeConfigResponse is the response struct for api DeleteServiceTimeConfig
type DeleteServiceTimeConfigResponse struct {
	*responses.BaseResponse
	Code    int    `json:"Code" xml:"Code"`
	Message string `json:"Message" xml:"Message"`
	Success bool   `json:"Success" xml:"Success"`
	Data    Data   `json:"Data" xml:"Data"`
}

// CreateDeleteServiceTimeConfigRequest creates a request to invoke DeleteServiceTimeConfig API
func CreateDeleteServiceTimeConfigRequest() (request *DeleteServiceTimeConfigRequest) {
	request = &DeleteServiceTimeConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DeleteServiceTimeConfig", "/pop/sp/api/timeout/remove", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteServiceTimeConfigResponse creates a response to parse from DeleteServiceTimeConfig response
func CreateDeleteServiceTimeConfigResponse() (response *DeleteServiceTimeConfigResponse) {
	response = &DeleteServiceTimeConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
