package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInvocationStatus invokes the ehpc.ListInvocationStatus API synchronously
func (client *Client) ListInvocationStatus(request *ListInvocationStatusRequest) (response *ListInvocationStatusResponse, err error) {
	response = CreateListInvocationStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ListInvocationStatusWithChan invokes the ehpc.ListInvocationStatus API asynchronously
func (client *Client) ListInvocationStatusWithChan(request *ListInvocationStatusRequest) (<-chan *ListInvocationStatusResponse, <-chan error) {
	responseChan := make(chan *ListInvocationStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInvocationStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInvocationStatusWithCallback invokes the ehpc.ListInvocationStatus API asynchronously
func (client *Client) ListInvocationStatusWithCallback(request *ListInvocationStatusRequest, callback func(response *ListInvocationStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInvocationStatusResponse
		var err error
		defer close(result)
		response, err = client.ListInvocationStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInvocationStatusRequest is the request struct for api ListInvocationStatus
type ListInvocationStatusRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
	CommandId string `position:"Query" name:"CommandId"`
}

// ListInvocationStatusResponse is the response struct for api ListInvocationStatus
type ListInvocationStatusResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	CommandId       string          `json:"CommandId" xml:"CommandId"`
	InvokeStatus    string          `json:"InvokeStatus" xml:"InvokeStatus"`
	InvokeInstances InvokeInstances `json:"InvokeInstances" xml:"InvokeInstances"`
}

// CreateListInvocationStatusRequest creates a request to invoke ListInvocationStatus API
func CreateListInvocationStatusRequest() (request *ListInvocationStatusRequest) {
	request = &ListInvocationStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "ListInvocationStatus", "", "")
	request.Method = requests.GET
	return
}

// CreateListInvocationStatusResponse creates a response to parse from ListInvocationStatus response
func CreateListInvocationStatusResponse() (response *ListInvocationStatusResponse) {
	response = &ListInvocationStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
