package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNodesByQueue invokes the ehpc.ListNodesByQueue API synchronously
func (client *Client) ListNodesByQueue(request *ListNodesByQueueRequest) (response *ListNodesByQueueResponse, err error) {
	response = CreateListNodesByQueueResponse()
	err = client.DoAction(request, response)
	return
}

// ListNodesByQueueWithChan invokes the ehpc.ListNodesByQueue API asynchronously
func (client *Client) ListNodesByQueueWithChan(request *ListNodesByQueueRequest) (<-chan *ListNodesByQueueResponse, <-chan error) {
	responseChan := make(chan *ListNodesByQueueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNodesByQueue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNodesByQueueWithCallback invokes the ehpc.ListNodesByQueue API asynchronously
func (client *Client) ListNodesByQueueWithCallback(request *ListNodesByQueueRequest, callback func(response *ListNodesByQueueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNodesByQueueResponse
		var err error
		defer close(result)
		response, err = client.ListNodesByQueue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNodesByQueueRequest is the request struct for api ListNodesByQueue
type ListNodesByQueueRequest struct {
	*requests.RpcRequest
	QueueName  string           `position:"Query" name:"QueueName"`
	ClusterId  string           `position:"Query" name:"ClusterId"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListNodesByQueueResponse is the response struct for api ListNodesByQueue
type ListNodesByQueueResponse struct {
	*responses.BaseResponse
	RequestId  string                  `json:"RequestId" xml:"RequestId"`
	TotalCount int                     `json:"TotalCount" xml:"TotalCount"`
	PageNumber int                     `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                     `json:"PageSize" xml:"PageSize"`
	Nodes      NodesInListNodesByQueue `json:"Nodes" xml:"Nodes"`
}

// CreateListNodesByQueueRequest creates a request to invoke ListNodesByQueue API
func CreateListNodesByQueueRequest() (request *ListNodesByQueueRequest) {
	request = &ListNodesByQueueRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "ListNodesByQueue", "", "")
	request.Method = requests.GET
	return
}

// CreateListNodesByQueueResponse creates a response to parse from ListNodesByQueue response
func CreateListNodesByQueueResponse() (response *ListNodesByQueueResponse) {
	response = &ListNodesByQueueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
