package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateSlrPermission invokes the elasticsearch.ValidateSlrPermission API synchronously
func (client *Client) ValidateSlrPermission(request *ValidateSlrPermissionRequest) (response *ValidateSlrPermissionResponse, err error) {
	response = CreateValidateSlrPermissionResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateSlrPermissionWithChan invokes the elasticsearch.ValidateSlrPermission API asynchronously
func (client *Client) ValidateSlrPermissionWithChan(request *ValidateSlrPermissionRequest) (<-chan *ValidateSlrPermissionResponse, <-chan error) {
	responseChan := make(chan *ValidateSlrPermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateSlrPermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateSlrPermissionWithCallback invokes the elasticsearch.ValidateSlrPermission API asynchronously
func (client *Client) ValidateSlrPermissionWithCallback(request *ValidateSlrPermissionRequest, callback func(response *ValidateSlrPermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateSlrPermissionResponse
		var err error
		defer close(result)
		response, err = client.ValidateSlrPermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateSlrPermissionRequest is the request struct for api ValidateSlrPermission
type ValidateSlrPermissionRequest struct {
	*requests.RoaRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	Rolename    string `position:"Query" name:"rolename"`
}

// ValidateSlrPermissionResponse is the response struct for api ValidateSlrPermission
type ValidateSlrPermissionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateValidateSlrPermissionRequest creates a request to invoke ValidateSlrPermission API
func CreateValidateSlrPermissionRequest() (request *ValidateSlrPermissionRequest) {
	request = &ValidateSlrPermissionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ValidateSlrPermission", "/openapi/user/servicerolepermission", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateValidateSlrPermissionResponse creates a response to parse from ValidateSlrPermission response
func CreateValidateSlrPermissionResponse() (response *ValidateSlrPermissionResponse) {
	response = &ValidateSlrPermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
