package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterServiceComponent invokes the emr.ListClusterServiceComponent API synchronously
func (client *Client) ListClusterServiceComponent(request *ListClusterServiceComponentRequest) (response *ListClusterServiceComponentResponse, err error) {
	response = CreateListClusterServiceComponentResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterServiceComponentWithChan invokes the emr.ListClusterServiceComponent API asynchronously
func (client *Client) ListClusterServiceComponentWithChan(request *ListClusterServiceComponentRequest) (<-chan *ListClusterServiceComponentResponse, <-chan error) {
	responseChan := make(chan *ListClusterServiceComponentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterServiceComponent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterServiceComponentWithCallback invokes the emr.ListClusterServiceComponent API asynchronously
func (client *Client) ListClusterServiceComponentWithCallback(request *ListClusterServiceComponentRequest, callback func(response *ListClusterServiceComponentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterServiceComponentResponse
		var err error
		defer close(result)
		response, err = client.ListClusterServiceComponent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterServiceComponentRequest is the request struct for api ListClusterServiceComponent
type ListClusterServiceComponentRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PodName         string           `position:"Query" name:"PodName"`
	ComponentName   string           `position:"Query" name:"ComponentName"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ComponentStatus string           `position:"Query" name:"ComponentStatus"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ServiceName     string           `position:"Query" name:"ServiceName"`
}

// ListClusterServiceComponentResponse is the response struct for api ListClusterServiceComponent
type ListClusterServiceComponentResponse struct {
	*responses.BaseResponse
	RequestId     string                                     `json:"RequestId" xml:"RequestId"`
	PageNumber    int                                        `json:"PageNumber" xml:"PageNumber"`
	PageSize      int                                        `json:"PageSize" xml:"PageSize"`
	Total         int                                        `json:"Total" xml:"Total"`
	ComponentList ComponentListInListClusterServiceComponent `json:"ComponentList" xml:"ComponentList"`
}

// CreateListClusterServiceComponentRequest creates a request to invoke ListClusterServiceComponent API
func CreateListClusterServiceComponentRequest() (request *ListClusterServiceComponentRequest) {
	request = &ListClusterServiceComponentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListClusterServiceComponent", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListClusterServiceComponentResponse creates a response to parse from ListClusterServiceComponent response
func CreateListClusterServiceComponentResponse() (response *ListClusterServiceComponentResponse) {
	response = &ListClusterServiceComponentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
