package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstanceSQLPatterns invokes the gpdb.DescribeDBInstanceSQLPatterns API synchronously
func (client *Client) DescribeDBInstanceSQLPatterns(request *DescribeDBInstanceSQLPatternsRequest) (response *DescribeDBInstanceSQLPatternsResponse, err error) {
	response = CreateDescribeDBInstanceSQLPatternsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstanceSQLPatternsWithChan invokes the gpdb.DescribeDBInstanceSQLPatterns API asynchronously
func (client *Client) DescribeDBInstanceSQLPatternsWithChan(request *DescribeDBInstanceSQLPatternsRequest) (<-chan *DescribeDBInstanceSQLPatternsResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstanceSQLPatternsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstanceSQLPatterns(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstanceSQLPatternsWithCallback invokes the gpdb.DescribeDBInstanceSQLPatterns API asynchronously
func (client *Client) DescribeDBInstanceSQLPatternsWithCallback(request *DescribeDBInstanceSQLPatternsRequest, callback func(response *DescribeDBInstanceSQLPatternsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstanceSQLPatternsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstanceSQLPatterns(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstanceSQLPatternsRequest is the request struct for api DescribeDBInstanceSQLPatterns
type DescribeDBInstanceSQLPatternsRequest struct {
	*requests.RpcRequest
	StartTime     string `position:"Query" name:"StartTime"`
	QueryKeywords string `position:"Query" name:"QueryKeywords"`
	Database      string `position:"Query" name:"Database"`
	SourceIP      string `position:"Query" name:"SourceIP"`
	DBInstanceId  string `position:"Query" name:"DBInstanceId"`
	EndTime       string `position:"Query" name:"EndTime"`
	User          string `position:"Query" name:"User"`
}

// DescribeDBInstanceSQLPatternsResponse is the response struct for api DescribeDBInstanceSQLPatterns
type DescribeDBInstanceSQLPatternsResponse struct {
	*responses.BaseResponse
	EndTime     string    `json:"EndTime" xml:"EndTime"`
	RequestId   string    `json:"RequestId" xml:"RequestId"`
	StartTime   string    `json:"StartTime" xml:"StartTime"`
	DBClusterId string    `json:"DBClusterId" xml:"DBClusterId"`
	Patterns    []Pattern `json:"Patterns" xml:"Patterns"`
}

// CreateDescribeDBInstanceSQLPatternsRequest creates a request to invoke DescribeDBInstanceSQLPatterns API
func CreateDescribeDBInstanceSQLPatternsRequest() (request *DescribeDBInstanceSQLPatternsRequest) {
	request = &DescribeDBInstanceSQLPatternsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeDBInstanceSQLPatterns", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDBInstanceSQLPatternsResponse creates a response to parse from DescribeDBInstanceSQLPatterns response
func CreateDescribeDBInstanceSQLPatternsResponse() (response *DescribeDBInstanceSQLPatternsResponse) {
	response = &DescribeDBInstanceSQLPatternsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
