package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateStatisticsRecord invokes the idrsservice.CreateStatisticsRecord API synchronously
func (client *Client) CreateStatisticsRecord(request *CreateStatisticsRecordRequest) (response *CreateStatisticsRecordResponse, err error) {
	response = CreateCreateStatisticsRecordResponse()
	err = client.DoAction(request, response)
	return
}

// CreateStatisticsRecordWithChan invokes the idrsservice.CreateStatisticsRecord API asynchronously
func (client *Client) CreateStatisticsRecordWithChan(request *CreateStatisticsRecordRequest) (<-chan *CreateStatisticsRecordResponse, <-chan error) {
	responseChan := make(chan *CreateStatisticsRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateStatisticsRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateStatisticsRecordWithCallback invokes the idrsservice.CreateStatisticsRecord API asynchronously
func (client *Client) CreateStatisticsRecordWithCallback(request *CreateStatisticsRecordRequest, callback func(response *CreateStatisticsRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateStatisticsRecordResponse
		var err error
		defer close(result)
		response, err = client.CreateStatisticsRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateStatisticsRecordRequest is the request struct for api CreateStatisticsRecord
type CreateStatisticsRecordRequest struct {
	*requests.RpcRequest
	BeginAt     string           `position:"Query" name:"BeginAt"`
	ClientToken string           `position:"Query" name:"ClientToken"`
	EndAt       string           `position:"Query" name:"EndAt"`
	DeviceId    string           `position:"Query" name:"DeviceId"`
	DeviceType  requests.Integer `position:"Query" name:"DeviceType"`
	AppId       string           `position:"Query" name:"AppId"`
}

// CreateStatisticsRecordResponse is the response struct for api CreateStatisticsRecord
type CreateStatisticsRecordResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateStatisticsRecordRequest creates a request to invoke CreateStatisticsRecord API
func CreateCreateStatisticsRecordRequest() (request *CreateStatisticsRecordRequest) {
	request = &CreateStatisticsRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "CreateStatisticsRecord", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateStatisticsRecordResponse creates a response to parse from CreateStatisticsRecord response
func CreateCreateStatisticsRecordResponse() (response *CreateStatisticsRecordResponse) {
	response = &CreateStatisticsRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
