package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDynamicGroupDevices invokes the iot.QueryDynamicGroupDevices API synchronously
func (client *Client) QueryDynamicGroupDevices(request *QueryDynamicGroupDevicesRequest) (response *QueryDynamicGroupDevicesResponse, err error) {
	response = CreateQueryDynamicGroupDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDynamicGroupDevicesWithChan invokes the iot.QueryDynamicGroupDevices API asynchronously
func (client *Client) QueryDynamicGroupDevicesWithChan(request *QueryDynamicGroupDevicesRequest) (<-chan *QueryDynamicGroupDevicesResponse, <-chan error) {
	responseChan := make(chan *QueryDynamicGroupDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDynamicGroupDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDynamicGroupDevicesWithCallback invokes the iot.QueryDynamicGroupDevices API asynchronously
func (client *Client) QueryDynamicGroupDevicesWithCallback(request *QueryDynamicGroupDevicesRequest, callback func(response *QueryDynamicGroupDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDynamicGroupDevicesResponse
		var err error
		defer close(result)
		response, err = client.QueryDynamicGroupDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDynamicGroupDevicesRequest is the request struct for api QueryDynamicGroupDevices
type QueryDynamicGroupDevicesRequest struct {
	*requests.RpcRequest
	NextToken     string           `position:"Query" name:"NextToken"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	FuzzyName     requests.Boolean `position:"Query" name:"FuzzyName"`
	GroupId       string           `position:"Query" name:"GroupId"`
	CurrentPage   requests.Integer `position:"Query" name:"CurrentPage"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
	Status        string           `position:"Query" name:"Status"`
}

// QueryDynamicGroupDevicesResponse is the response struct for api QueryDynamicGroupDevices
type QueryDynamicGroupDevicesResponse struct {
	*responses.BaseResponse
	RequestId    string                         `json:"RequestId" xml:"RequestId"`
	Success      bool                           `json:"Success" xml:"Success"`
	Code         string                         `json:"Code" xml:"Code"`
	ErrorMessage string                         `json:"ErrorMessage" xml:"ErrorMessage"`
	Page         int                            `json:"Page" xml:"Page"`
	PageSize     int                            `json:"PageSize" xml:"PageSize"`
	PageCount    int                            `json:"PageCount" xml:"PageCount"`
	Total        int                            `json:"Total" xml:"Total"`
	NextToken    string                         `json:"NextToken" xml:"NextToken"`
	Data         DataInQueryDynamicGroupDevices `json:"Data" xml:"Data"`
}

// CreateQueryDynamicGroupDevicesRequest creates a request to invoke QueryDynamicGroupDevices API
func CreateQueryDynamicGroupDevicesRequest() (request *QueryDynamicGroupDevicesRequest) {
	request = &QueryDynamicGroupDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryDynamicGroupDevices", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryDynamicGroupDevicesResponse creates a response to parse from QueryDynamicGroupDevices response
func CreateQueryDynamicGroupDevicesResponse() (response *QueryDynamicGroupDevicesResponse) {
	response = &QueryDynamicGroupDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
