package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainWithIntegrity invokes the live.DescribeDomainWithIntegrity API synchronously
func (client *Client) DescribeDomainWithIntegrity(request *DescribeDomainWithIntegrityRequest) (response *DescribeDomainWithIntegrityResponse, err error) {
	response = CreateDescribeDomainWithIntegrityResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainWithIntegrityWithChan invokes the live.DescribeDomainWithIntegrity API asynchronously
func (client *Client) DescribeDomainWithIntegrityWithChan(request *DescribeDomainWithIntegrityRequest) (<-chan *DescribeDomainWithIntegrityResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainWithIntegrityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainWithIntegrity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainWithIntegrityWithCallback invokes the live.DescribeDomainWithIntegrity API asynchronously
func (client *Client) DescribeDomainWithIntegrityWithCallback(request *DescribeDomainWithIntegrityRequest, callback func(response *DescribeDomainWithIntegrityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainWithIntegrityResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainWithIntegrity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainWithIntegrityRequest is the request struct for api DescribeDomainWithIntegrity
type DescribeDomainWithIntegrityRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	Integrity requests.Float   `position:"Query" name:"Integrity"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDomainWithIntegrityResponse is the response struct for api DescribeDomainWithIntegrity
type DescribeDomainWithIntegrityResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Content   []Content `json:"Content" xml:"Content"`
}

// CreateDescribeDomainWithIntegrityRequest creates a request to invoke DescribeDomainWithIntegrity API
func CreateDescribeDomainWithIntegrityRequest() (request *DescribeDomainWithIntegrityRequest) {
	request = &DescribeDomainWithIntegrityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeDomainWithIntegrity", "live", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeDomainWithIntegrityResponse creates a response to parse from DescribeDomainWithIntegrity response
func CreateDescribeDomainWithIntegrityResponse() (response *DescribeDomainWithIntegrityResponse) {
	response = &DescribeDomainWithIntegrityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
