package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryInferenceJob invokes the mts.QueryInferenceJob API synchronously
func (client *Client) QueryInferenceJob(request *QueryInferenceJobRequest) (response *QueryInferenceJobResponse, err error) {
	response = CreateQueryInferenceJobResponse()
	err = client.DoAction(request, response)
	return
}

// QueryInferenceJobWithChan invokes the mts.QueryInferenceJob API asynchronously
func (client *Client) QueryInferenceJobWithChan(request *QueryInferenceJobRequest) (<-chan *QueryInferenceJobResponse, <-chan error) {
	responseChan := make(chan *QueryInferenceJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryInferenceJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryInferenceJobWithCallback invokes the mts.QueryInferenceJob API asynchronously
func (client *Client) QueryInferenceJobWithCallback(request *QueryInferenceJobRequest, callback func(response *QueryInferenceJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryInferenceJobResponse
		var err error
		defer close(result)
		response, err = client.QueryInferenceJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryInferenceJobRequest is the request struct for api QueryInferenceJob
type QueryInferenceJobRequest struct {
	*requests.RpcRequest
	JobId string `position:"Query" name:"JobId"`
}

// QueryInferenceJobResponse is the response struct for api QueryInferenceJob
type QueryInferenceJobResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Job       Job    `json:"Job" xml:"Job"`
}

// CreateQueryInferenceJobRequest creates a request to invoke QueryInferenceJob API
func CreateQueryInferenceJobRequest() (request *QueryInferenceJobRequest) {
	request = &QueryInferenceJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryInferenceJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryInferenceJobResponse creates a response to parse from QueryInferenceJob response
func CreateQueryInferenceJobResponse() (response *QueryInferenceJobResponse) {
	response = &QueryInferenceJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
