package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitURLUploadJob invokes the mts.SubmitURLUploadJob API synchronously
func (client *Client) SubmitURLUploadJob(request *SubmitURLUploadJobRequest) (response *SubmitURLUploadJobResponse, err error) {
	response = CreateSubmitURLUploadJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitURLUploadJobWithChan invokes the mts.SubmitURLUploadJob API asynchronously
func (client *Client) SubmitURLUploadJobWithChan(request *SubmitURLUploadJobRequest) (<-chan *SubmitURLUploadJobResponse, <-chan error) {
	responseChan := make(chan *SubmitURLUploadJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitURLUploadJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitURLUploadJobWithCallback invokes the mts.SubmitURLUploadJob API asynchronously
func (client *Client) SubmitURLUploadJobWithCallback(request *SubmitURLUploadJobRequest, callback func(response *SubmitURLUploadJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitURLUploadJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitURLUploadJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitURLUploadJobRequest is the request struct for api SubmitURLUploadJob
type SubmitURLUploadJobRequest struct {
	*requests.RpcRequest
	TargetStorage SubmitURLUploadJobTargetStorage `position:"Query" name:"TargetStorage"  type:"Struct"`
	SourceFileURL string                          `position:"Query" name:"SourceFileURL"`
	Notify        string                          `position:"Query" name:"Notify"`
	UserData      string                          `position:"Query" name:"UserData"`
	Region        string                          `position:"Query" name:"Region"`
}

// SubmitURLUploadJobTargetStorage is a repeated param struct in SubmitURLUploadJobRequest
type SubmitURLUploadJobTargetStorage struct {
	Bucket         string `name:"Bucket"`
	BucketOwnerId  string `name:"BucketOwnerId"`
	S3Provider     string `name:"S3Provider"`
	S3Endpoint     string `name:"S3Endpoint"`
	ObjectKey      string `name:"ObjectKey"`
	S3AccessKey    string `name:"S3AccessKey"`
	S3SecretKey    string `name:"S3SecretKey"`
	S3SessionToken string `name:"S3SessionToken"`
	ObjectRoleName string `name:"ObjectRoleName"`
}

// SubmitURLUploadJobResponse is the response struct for api SubmitURLUploadJob
type SubmitURLUploadJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateSubmitURLUploadJobRequest creates a request to invoke SubmitURLUploadJob API
func CreateSubmitURLUploadJobRequest() (request *SubmitURLUploadJobRequest) {
	request = &SubmitURLUploadJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitURLUploadJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitURLUploadJobResponse creates a response to parse from SubmitURLUploadJob response
func CreateSubmitURLUploadJobResponse() (response *SubmitURLUploadJobResponse) {
	response = &SubmitURLUploadJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
