package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitVideoQualityJob invokes the mts.SubmitVideoQualityJob API synchronously
func (client *Client) SubmitVideoQualityJob(request *SubmitVideoQualityJobRequest) (response *SubmitVideoQualityJobResponse, err error) {
	response = CreateSubmitVideoQualityJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitVideoQualityJobWithChan invokes the mts.SubmitVideoQualityJob API asynchronously
func (client *Client) SubmitVideoQualityJobWithChan(request *SubmitVideoQualityJobRequest) (<-chan *SubmitVideoQualityJobResponse, <-chan error) {
	responseChan := make(chan *SubmitVideoQualityJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitVideoQualityJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitVideoQualityJobWithCallback invokes the mts.SubmitVideoQualityJob API asynchronously
func (client *Client) SubmitVideoQualityJobWithCallback(request *SubmitVideoQualityJobRequest, callback func(response *SubmitVideoQualityJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitVideoQualityJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitVideoQualityJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitVideoQualityJobRequest is the request struct for api SubmitVideoQualityJob
type SubmitVideoQualityJobRequest struct {
	*requests.RpcRequest
	JobParams      string           `position:"Query" name:"JobParams"`
	UserId         requests.Integer `position:"Query" name:"UserId"`
	Output         string           `position:"Query" name:"Output"`
	UserData       string           `position:"Query" name:"UserData"`
	NotifyUrl      string           `position:"Query" name:"NotifyUrl"`
	SourceType     string           `position:"Query" name:"SourceType"`
	ModelId        string           `position:"Query" name:"ModelId"`
	PipelineId     string           `position:"Query" name:"PipelineId"`
	Input          string           `position:"Query" name:"Input"`
	ScheduleParams string           `position:"Query" name:"ScheduleParams"`
}

// SubmitVideoQualityJobResponse is the response struct for api SubmitVideoQualityJob
type SubmitVideoQualityJobResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateSubmitVideoQualityJobRequest creates a request to invoke SubmitVideoQualityJob API
func CreateSubmitVideoQualityJobRequest() (request *SubmitVideoQualityJobRequest) {
	request = &SubmitVideoQualityJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitVideoQualityJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitVideoQualityJobResponse creates a response to parse from SubmitVideoQualityJob response
func CreateSubmitVideoQualityJobResponse() (response *SubmitVideoQualityJobResponse) {
	response = &SubmitVideoQualityJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
