package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyRole invokes the oam.ModifyRole API synchronously
// api document: https://help.aliyun.com/api/oam/modifyrole.html
func (client *Client) ModifyRole(request *ModifyRoleRequest) (response *ModifyRoleResponse, err error) {
	response = CreateModifyRoleResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyRoleWithChan invokes the oam.ModifyRole API asynchronously
// api document: https://help.aliyun.com/api/oam/modifyrole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyRoleWithChan(request *ModifyRoleRequest) (<-chan *ModifyRoleResponse, <-chan error) {
	responseChan := make(chan *ModifyRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyRoleWithCallback invokes the oam.ModifyRole API asynchronously
// api document: https://help.aliyun.com/api/oam/modifyrole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyRoleWithCallback(request *ModifyRoleRequest, callback func(response *ModifyRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyRoleResponse
		var err error
		defer close(result)
		response, err = client.ModifyRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyRoleRequest is the request struct for api ModifyRole
type ModifyRoleRequest struct {
	*requests.RpcRequest
	NewRoleName    string `position:"Query" name:"NewRoleName"`
	RoleName       string `position:"Query" name:"RoleName"`
	NewAttribute   string `position:"Query" name:"NewAttribute"`
	NewRoleType    string `position:"Query" name:"NewRoleType"`
	NewDescription string `position:"Query" name:"NewDescription"`
}

// ModifyRoleResponse is the response struct for api ModifyRole
type ModifyRoleResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Message string `json:"Message" xml:"Message"`
}

// CreateModifyRoleRequest creates a request to invoke ModifyRole API
func CreateModifyRoleRequest() (request *ModifyRoleRequest) {
	request = &ModifyRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "ModifyRole", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyRoleResponse creates a response to parse from ModifyRole response
func CreateModifyRoleResponse() (response *ModifyRoleResponse) {
	response = &ModifyRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
