package objectdet

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVehicleRepairPlan invokes the objectdet.GetVehicleRepairPlan API synchronously
func (client *Client) GetVehicleRepairPlan(request *GetVehicleRepairPlanRequest) (response *GetVehicleRepairPlanResponse, err error) {
	response = CreateGetVehicleRepairPlanResponse()
	err = client.DoAction(request, response)
	return
}

// GetVehicleRepairPlanWithChan invokes the objectdet.GetVehicleRepairPlan API asynchronously
func (client *Client) GetVehicleRepairPlanWithChan(request *GetVehicleRepairPlanRequest) (<-chan *GetVehicleRepairPlanResponse, <-chan error) {
	responseChan := make(chan *GetVehicleRepairPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVehicleRepairPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVehicleRepairPlanWithCallback invokes the objectdet.GetVehicleRepairPlan API asynchronously
func (client *Client) GetVehicleRepairPlanWithCallback(request *GetVehicleRepairPlanRequest, callback func(response *GetVehicleRepairPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVehicleRepairPlanResponse
		var err error
		defer close(result)
		response, err = client.GetVehicleRepairPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVehicleRepairPlanRequest is the request struct for api GetVehicleRepairPlan
type GetVehicleRepairPlanRequest struct {
	*requests.RpcRequest
	VinCodeImage   string `position:"Body" name:"VinCodeImage"`
	CarNumberImage string `position:"Body" name:"CarNumberImage"`
	TaskId         string `position:"Body" name:"TaskId"`
}

// GetVehicleRepairPlanResponse is the response struct for api GetVehicleRepairPlan
type GetVehicleRepairPlanResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	HttpCode     int    `json:"HttpCode" xml:"HttpCode"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateGetVehicleRepairPlanRequest creates a request to invoke GetVehicleRepairPlan API
func CreateGetVehicleRepairPlanRequest() (request *GetVehicleRepairPlanRequest) {
	request = &GetVehicleRepairPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("objectdet", "2019-12-30", "GetVehicleRepairPlan", "objectdet", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetVehicleRepairPlanResponse creates a response to parse from GetVehicleRepairPlan response
func CreateGetVehicleRepairPlanResponse() (response *GetVehicleRepairPlanResponse) {
	response = &GetVehicleRepairPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
