package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExecutionRiskyTasks invokes the oos.ListExecutionRiskyTasks API synchronously
func (client *Client) ListExecutionRiskyTasks(request *ListExecutionRiskyTasksRequest) (response *ListExecutionRiskyTasksResponse, err error) {
	response = CreateListExecutionRiskyTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ListExecutionRiskyTasksWithChan invokes the oos.ListExecutionRiskyTasks API asynchronously
func (client *Client) ListExecutionRiskyTasksWithChan(request *ListExecutionRiskyTasksRequest) (<-chan *ListExecutionRiskyTasksResponse, <-chan error) {
	responseChan := make(chan *ListExecutionRiskyTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExecutionRiskyTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExecutionRiskyTasksWithCallback invokes the oos.ListExecutionRiskyTasks API asynchronously
func (client *Client) ListExecutionRiskyTasksWithCallback(request *ListExecutionRiskyTasksRequest, callback func(response *ListExecutionRiskyTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExecutionRiskyTasksResponse
		var err error
		defer close(result)
		response, err = client.ListExecutionRiskyTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExecutionRiskyTasksRequest is the request struct for api ListExecutionRiskyTasks
type ListExecutionRiskyTasksRequest struct {
	*requests.RpcRequest
	TemplateName string `position:"Query" name:"TemplateName"`
}

// ListExecutionRiskyTasksResponse is the response struct for api ListExecutionRiskyTasks
type ListExecutionRiskyTasksResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	RiskyTasks []RiskyTask `json:"RiskyTasks" xml:"RiskyTasks"`
}

// CreateListExecutionRiskyTasksRequest creates a request to invoke ListExecutionRiskyTasks API
func CreateListExecutionRiskyTasksRequest() (request *ListExecutionRiskyTasksRequest) {
	request = &ListExecutionRiskyTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "ListExecutionRiskyTasks", "", "")
	request.Method = requests.POST
	return
}

// CreateListExecutionRiskyTasksResponse creates a response to parse from ListExecutionRiskyTasks response
func CreateListExecutionRiskyTasksResponse() (response *ListExecutionRiskyTasksResponse) {
	response = &ListExecutionRiskyTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
