package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSlowQueryQueries invokes the opensearch.ListSlowQueryQueries API synchronously
func (client *Client) ListSlowQueryQueries(request *ListSlowQueryQueriesRequest) (response *ListSlowQueryQueriesResponse, err error) {
	response = CreateListSlowQueryQueriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListSlowQueryQueriesWithChan invokes the opensearch.ListSlowQueryQueries API asynchronously
func (client *Client) ListSlowQueryQueriesWithChan(request *ListSlowQueryQueriesRequest) (<-chan *ListSlowQueryQueriesResponse, <-chan error) {
	responseChan := make(chan *ListSlowQueryQueriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSlowQueryQueries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSlowQueryQueriesWithCallback invokes the opensearch.ListSlowQueryQueries API asynchronously
func (client *Client) ListSlowQueryQueriesWithCallback(request *ListSlowQueryQueriesRequest, callback func(response *ListSlowQueryQueriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSlowQueryQueriesResponse
		var err error
		defer close(result)
		response, err = client.ListSlowQueryQueries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSlowQueryQueriesRequest is the request struct for api ListSlowQueryQueries
type ListSlowQueryQueriesRequest struct {
	*requests.RoaRequest
	CategoryIndex    string `position:"Path" name:"categoryIndex"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// ListSlowQueryQueriesResponse is the response struct for api ListSlowQueryQueries
type ListSlowQueryQueriesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateListSlowQueryQueriesRequest creates a request to invoke ListSlowQueryQueries API
func CreateListSlowQueryQueriesRequest() (request *ListSlowQueryQueriesRequest) {
	request = &ListSlowQueryQueriesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListSlowQueryQueries", "/v4/openapi/app-groups/[appGroupIdentity]/optimizers/slow-query/categories/[categoryIndex]/queries", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListSlowQueryQueriesResponse creates a response to parse from ListSlowQueryQueries response
func CreateListSlowQueryQueriesResponse() (response *ListSlowQueryQueriesResponse) {
	response = &ListSlowQueryQueriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
