package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListStatisticLogs invokes the opensearch.ListStatisticLogs API synchronously
func (client *Client) ListStatisticLogs(request *ListStatisticLogsRequest) (response *ListStatisticLogsResponse, err error) {
	response = CreateListStatisticLogsResponse()
	err = client.DoAction(request, response)
	return
}

// ListStatisticLogsWithChan invokes the opensearch.ListStatisticLogs API asynchronously
func (client *Client) ListStatisticLogsWithChan(request *ListStatisticLogsRequest) (<-chan *ListStatisticLogsResponse, <-chan error) {
	responseChan := make(chan *ListStatisticLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListStatisticLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListStatisticLogsWithCallback invokes the opensearch.ListStatisticLogs API asynchronously
func (client *Client) ListStatisticLogsWithCallback(request *ListStatisticLogsRequest, callback func(response *ListStatisticLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListStatisticLogsResponse
		var err error
		defer close(result)
		response, err = client.ListStatisticLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListStatisticLogsRequest is the request struct for api ListStatisticLogs
type ListStatisticLogsRequest struct {
	*requests.RoaRequest
	Columns          string           `position:"Query" name:"columns"`
	Query            string           `position:"Query" name:"query"`
	PageSize         requests.Integer `position:"Query" name:"pageSize"`
	ModuleName       string           `position:"Path" name:"moduleName"`
	Distinct         requests.Boolean `position:"Query" name:"distinct"`
	SortBy           string           `position:"Query" name:"sortBy"`
	StartTime        requests.Integer `position:"Query" name:"startTime"`
	StopTime         requests.Integer `position:"Query" name:"stopTime"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
	PageNumber       requests.Integer `position:"Query" name:"pageNumber"`
}

// ListStatisticLogsResponse is the response struct for api ListStatisticLogs
type ListStatisticLogsResponse struct {
	*responses.BaseResponse
	RequestId  string                   `json:"requestId" xml:"requestId"`
	TotalCount int64                    `json:"totalCount" xml:"totalCount"`
	Result     []map[string]interface{} `json:"result" xml:"result"`
}

// CreateListStatisticLogsRequest creates a request to invoke ListStatisticLogs API
func CreateListStatisticLogsRequest() (request *ListStatisticLogsRequest) {
	request = &ListStatisticLogsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListStatisticLogs", "/v4/openapi/app-groups/[appGroupIdentity]/statistic-logs/[moduleName]", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListStatisticLogsResponse creates a response to parse from ListStatisticLogs response
func CreateListStatisticLogsResponse() (response *ListStatisticLogsResponse) {
	response = &ListStatisticLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
