package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBNodeHotReplicaMode invokes the polardb.ModifyDBNodeHotReplicaMode API synchronously
func (client *Client) ModifyDBNodeHotReplicaMode(request *ModifyDBNodeHotReplicaModeRequest) (response *ModifyDBNodeHotReplicaModeResponse, err error) {
	response = CreateModifyDBNodeHotReplicaModeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBNodeHotReplicaModeWithChan invokes the polardb.ModifyDBNodeHotReplicaMode API asynchronously
func (client *Client) ModifyDBNodeHotReplicaModeWithChan(request *ModifyDBNodeHotReplicaModeRequest) (<-chan *ModifyDBNodeHotReplicaModeResponse, <-chan error) {
	responseChan := make(chan *ModifyDBNodeHotReplicaModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBNodeHotReplicaMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBNodeHotReplicaModeWithCallback invokes the polardb.ModifyDBNodeHotReplicaMode API asynchronously
func (client *Client) ModifyDBNodeHotReplicaModeWithCallback(request *ModifyDBNodeHotReplicaModeRequest, callback func(response *ModifyDBNodeHotReplicaModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBNodeHotReplicaModeResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBNodeHotReplicaMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBNodeHotReplicaModeRequest is the request struct for api ModifyDBNodeHotReplicaMode
type ModifyDBNodeHotReplicaModeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBNodeId             string           `position:"Query" name:"DBNodeId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	HotReplicaMode       string           `position:"Query" name:"HotReplicaMode"`
}

// ModifyDBNodeHotReplicaModeResponse is the response struct for api ModifyDBNodeHotReplicaMode
type ModifyDBNodeHotReplicaModeResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	DBClusterId string `json:"DBClusterId" xml:"DBClusterId"`
	OrderId     string `json:"OrderId" xml:"OrderId"`
}

// CreateModifyDBNodeHotReplicaModeRequest creates a request to invoke ModifyDBNodeHotReplicaMode API
func CreateModifyDBNodeHotReplicaModeRequest() (request *ModifyDBNodeHotReplicaModeRequest) {
	request = &ModifyDBNodeHotReplicaModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "ModifyDBNodeHotReplicaMode", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyDBNodeHotReplicaModeResponse creates a response to parse from ModifyDBNodeHotReplicaMode response
func CreateModifyDBNodeHotReplicaModeResponse() (response *ModifyDBNodeHotReplicaModeResponse) {
	response = &ModifyDBNodeHotReplicaModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
