package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDependentQuotas invokes the quotas.ListDependentQuotas API synchronously
func (client *Client) ListDependentQuotas(request *ListDependentQuotasRequest) (response *ListDependentQuotasResponse, err error) {
	response = CreateListDependentQuotasResponse()
	err = client.DoAction(request, response)
	return
}

// ListDependentQuotasWithChan invokes the quotas.ListDependentQuotas API asynchronously
func (client *Client) ListDependentQuotasWithChan(request *ListDependentQuotasRequest) (<-chan *ListDependentQuotasResponse, <-chan error) {
	responseChan := make(chan *ListDependentQuotasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDependentQuotas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDependentQuotasWithCallback invokes the quotas.ListDependentQuotas API asynchronously
func (client *Client) ListDependentQuotasWithCallback(request *ListDependentQuotasRequest, callback func(response *ListDependentQuotasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDependentQuotasResponse
		var err error
		defer close(result)
		response, err = client.ListDependentQuotas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDependentQuotasRequest is the request struct for api ListDependentQuotas
type ListDependentQuotasRequest struct {
	*requests.RpcRequest
	ProductCode     string `position:"Body" name:"ProductCode"`
	QuotaActionCode string `position:"Body" name:"QuotaActionCode"`
}

// ListDependentQuotasResponse is the response struct for api ListDependentQuotas
type ListDependentQuotasResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Quotas    []QuotasItem `json:"Quotas" xml:"Quotas"`
}

// CreateListDependentQuotasRequest creates a request to invoke ListDependentQuotas API
func CreateListDependentQuotasRequest() (request *ListDependentQuotasRequest) {
	request = &ListDependentQuotasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "ListDependentQuotas", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDependentQuotasResponse creates a response to parse from ListDependentQuotas response
func CreateListDependentQuotasResponse() (response *ListDependentQuotasResponse) {
	response = &ListDependentQuotasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
