package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveCloudAccount invokes the resourcemanager.RemoveCloudAccount API synchronously
func (client *Client) RemoveCloudAccount(request *RemoveCloudAccountRequest) (response *RemoveCloudAccountResponse, err error) {
	response = CreateRemoveCloudAccountResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveCloudAccountWithChan invokes the resourcemanager.RemoveCloudAccount API asynchronously
func (client *Client) RemoveCloudAccountWithChan(request *RemoveCloudAccountRequest) (<-chan *RemoveCloudAccountResponse, <-chan error) {
	responseChan := make(chan *RemoveCloudAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveCloudAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveCloudAccountWithCallback invokes the resourcemanager.RemoveCloudAccount API asynchronously
func (client *Client) RemoveCloudAccountWithCallback(request *RemoveCloudAccountRequest, callback func(response *RemoveCloudAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveCloudAccountResponse
		var err error
		defer close(result)
		response, err = client.RemoveCloudAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveCloudAccountRequest is the request struct for api RemoveCloudAccount
type RemoveCloudAccountRequest struct {
	*requests.RpcRequest
	AccountId string `position:"Query" name:"AccountId"`
}

// RemoveCloudAccountResponse is the response struct for api RemoveCloudAccount
type RemoveCloudAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveCloudAccountRequest creates a request to invoke RemoveCloudAccount API
func CreateRemoveCloudAccountRequest() (request *RemoveCloudAccountRequest) {
	request = &RemoveCloudAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "RemoveCloudAccount", "", "")
	request.Method = requests.POST
	return
}

// CreateRemoveCloudAccountResponse creates a response to parse from RemoveCloudAccount response
func CreateRemoveCloudAccountResponse() (response *RemoveCloudAccountResponse) {
	response = &RemoveCloudAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
