package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMPUTask invokes the rtc.UpdateMPUTask API synchronously
func (client *Client) UpdateMPUTask(request *UpdateMPUTaskRequest) (response *UpdateMPUTaskResponse, err error) {
	response = CreateUpdateMPUTaskResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMPUTaskWithChan invokes the rtc.UpdateMPUTask API asynchronously
func (client *Client) UpdateMPUTaskWithChan(request *UpdateMPUTaskRequest) (<-chan *UpdateMPUTaskResponse, <-chan error) {
	responseChan := make(chan *UpdateMPUTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMPUTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMPUTaskWithCallback invokes the rtc.UpdateMPUTask API asynchronously
func (client *Client) UpdateMPUTaskWithCallback(request *UpdateMPUTaskRequest, callback func(response *UpdateMPUTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMPUTaskResponse
		var err error
		defer close(result)
		response, err = client.UpdateMPUTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMPUTaskRequest is the request struct for api UpdateMPUTask
type UpdateMPUTaskRequest struct {
	*requests.RpcRequest
	UserPanes                 *[]UpdateMPUTaskUserPanes    `position:"Query" name:"UserPanes"  type:"Repeated"`
	BackgroundColor           requests.Integer             `position:"Query" name:"BackgroundColor"`
	SourceType                string                       `position:"Query" name:"SourceType"`
	TaskId                    string                       `position:"Query" name:"TaskId"`
	ClockWidgets              *[]UpdateMPUTaskClockWidgets `position:"Query" name:"ClockWidgets"  type:"Repeated"`
	ShowLog                   string                       `position:"Query" name:"ShowLog"`
	UnsubSpecCameraUsers      *[]string                    `position:"Query" name:"UnsubSpecCameraUsers"  type:"Repeated"`
	UnsubSpecAudioUsers       *[]string                    `position:"Query" name:"UnsubSpecAudioUsers"  type:"Repeated"`
	Watermarks                *[]UpdateMPUTaskWatermarks   `position:"Query" name:"Watermarks"  type:"Repeated"`
	OwnerId                   requests.Integer             `position:"Query" name:"OwnerId"`
	SubSpecAudioUsers         *[]string                    `position:"Query" name:"SubSpecAudioUsers"  type:"Repeated"`
	MediaEncode               requests.Integer             `position:"Query" name:"MediaEncode"`
	EnhancedParam             UpdateMPUTaskEnhancedParam   `position:"Body" name:"EnhancedParam"  type:"Struct"`
	CropMode                  requests.Integer             `position:"Query" name:"CropMode"`
	SubSpecCameraUsers        *[]string                    `position:"Query" name:"SubSpecCameraUsers"  type:"Repeated"`
	TaskProfile               string                       `position:"Query" name:"TaskProfile"`
	LayoutIds                 *[]string                    `position:"Query" name:"LayoutIds"  type:"Repeated"`
	StreamType                requests.Integer             `position:"Query" name:"StreamType"`
	UnsubSpecShareScreenUsers *[]string                    `position:"Query" name:"UnsubSpecShareScreenUsers"  type:"Repeated"`
	SubSpecShareScreenUsers   *[]string                    `position:"Query" name:"SubSpecShareScreenUsers"  type:"Repeated"`
	SubSpecUsers              *[]string                    `position:"Query" name:"SubSpecUsers"  type:"Repeated"`
	AppId                     string                       `position:"Query" name:"AppId"`
	Backgrounds               *[]UpdateMPUTaskBackgrounds  `position:"Query" name:"Backgrounds"  type:"Repeated"`
	MixMode                   requests.Integer             `position:"Query" name:"MixMode"`
}

// UpdateMPUTaskUserPanes is a repeated param struct in UpdateMPUTaskRequest
type UpdateMPUTaskUserPanes struct {
	Images      *[]UpdateMPUTaskUserPanesImages `name:"Images" type:"Repeated"`
	SegmentType string                          `name:"SegmentType"`
	UserId      string                          `name:"UserId"`
	Texts       *[]UpdateMPUTaskUserPanesTexts  `name:"Texts" type:"Repeated"`
	SourceType  string                          `name:"SourceType"`
	PaneId      string                          `name:"PaneId"`
}

// UpdateMPUTaskClockWidgets is a repeated param struct in UpdateMPUTaskRequest
type UpdateMPUTaskClockWidgets struct {
	FontType  string `name:"FontType"`
	FontColor string `name:"FontColor"`
	Y         string `name:"Y"`
	ZOrder    string `name:"ZOrder"`
	X         string `name:"X"`
	FontSize  string `name:"FontSize"`
}

// UpdateMPUTaskWatermarks is a repeated param struct in UpdateMPUTaskRequest
type UpdateMPUTaskWatermarks struct {
	Alpha   string `name:"Alpha"`
	Width   string `name:"Width"`
	Height  string `name:"Height"`
	Y       string `name:"Y"`
	Url     string `name:"Url"`
	Display string `name:"Display"`
	ZOrder  string `name:"ZOrder"`
	X       string `name:"X"`
}

// UpdateMPUTaskEnhancedParam is a repeated param struct in UpdateMPUTaskRequest
type UpdateMPUTaskEnhancedParam struct {
	EnablePortraitSegmentation string `name:"EnablePortraitSegmentation"`
	EnableVirtualConference    string `name:"EnableVirtualConference"`
	EnableCartoonPortrait      string `name:"EnableCartoonPortrait"`
	EnableVoiceChanger         string `name:"EnableVoiceChanger"`
	EnableUserPaneBackground   string `name:"EnableUserPaneBackground"`
	BackgroundPath             string `name:"BackgroundPath"`
}

// UpdateMPUTaskBackgrounds is a repeated param struct in UpdateMPUTaskRequest
type UpdateMPUTaskBackgrounds struct {
	Width   string `name:"Width"`
	Height  string `name:"Height"`
	Y       string `name:"Y"`
	Url     string `name:"Url"`
	Display string `name:"Display"`
	ZOrder  string `name:"ZOrder"`
	X       string `name:"X"`
}

// UpdateMPUTaskUserPanesImages is a repeated param struct in UpdateMPUTaskRequest
type UpdateMPUTaskUserPanesImages struct {
	Width   string `name:"Width"`
	Height  string `name:"Height"`
	Y       string `name:"Y"`
	Url     string `name:"Url"`
	Display string `name:"Display"`
	ZOrder  string `name:"ZOrder"`
	X       string `name:"X"`
}

// UpdateMPUTaskUserPanesTexts is a repeated param struct in UpdateMPUTaskRequest
type UpdateMPUTaskUserPanesTexts struct {
	FontType  string `name:"FontType"`
	FontColor string `name:"FontColor"`
	Y         string `name:"Y"`
	Text      string `name:"Text"`
	ZOrder    string `name:"ZOrder"`
	X         string `name:"X"`
	FontSize  string `name:"FontSize"`
}

// UpdateMPUTaskResponse is the response struct for api UpdateMPUTask
type UpdateMPUTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateMPUTaskRequest creates a request to invoke UpdateMPUTask API
func CreateUpdateMPUTaskRequest() (request *UpdateMPUTaskRequest) {
	request = &UpdateMPUTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "UpdateMPUTask", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateMPUTaskResponse creates a response to parse from UpdateMPUTask response
func CreateUpdateMPUTaskResponse() (response *UpdateMPUTaskResponse) {
	response = &UpdateMPUTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
