package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserLayoutAuthorization invokes the sas.DescribeUserLayoutAuthorization API synchronously
func (client *Client) DescribeUserLayoutAuthorization(request *DescribeUserLayoutAuthorizationRequest) (response *DescribeUserLayoutAuthorizationResponse, err error) {
	response = CreateDescribeUserLayoutAuthorizationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserLayoutAuthorizationWithChan invokes the sas.DescribeUserLayoutAuthorization API asynchronously
func (client *Client) DescribeUserLayoutAuthorizationWithChan(request *DescribeUserLayoutAuthorizationRequest) (<-chan *DescribeUserLayoutAuthorizationResponse, <-chan error) {
	responseChan := make(chan *DescribeUserLayoutAuthorizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserLayoutAuthorization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserLayoutAuthorizationWithCallback invokes the sas.DescribeUserLayoutAuthorization API asynchronously
func (client *Client) DescribeUserLayoutAuthorizationWithCallback(request *DescribeUserLayoutAuthorizationRequest, callback func(response *DescribeUserLayoutAuthorizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserLayoutAuthorizationResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserLayoutAuthorization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserLayoutAuthorizationRequest is the request struct for api DescribeUserLayoutAuthorization
type DescribeUserLayoutAuthorizationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Lang            string           `position:"Query" name:"Lang"`
}

// DescribeUserLayoutAuthorizationResponse is the response struct for api DescribeUserLayoutAuthorization
type DescribeUserLayoutAuthorizationResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Authorized bool   `json:"Authorized" xml:"Authorized"`
}

// CreateDescribeUserLayoutAuthorizationRequest creates a request to invoke DescribeUserLayoutAuthorization API
func CreateDescribeUserLayoutAuthorizationRequest() (request *DescribeUserLayoutAuthorizationRequest) {
	request = &DescribeUserLayoutAuthorizationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeUserLayoutAuthorization", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeUserLayoutAuthorizationResponse creates a response to parse from DescribeUserLayoutAuthorization response
func CreateDescribeUserLayoutAuthorizationResponse() (response *DescribeUserLayoutAuthorizationResponse) {
	response = &DescribeUserLayoutAuthorizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
