package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefreshContainerAsserts invokes the sas.RefreshContainerAsserts API synchronously
func (client *Client) RefreshContainerAsserts(request *RefreshContainerAssertsRequest) (response *RefreshContainerAssertsResponse, err error) {
	response = CreateRefreshContainerAssertsResponse()
	err = client.DoAction(request, response)
	return
}

// RefreshContainerAssertsWithChan invokes the sas.RefreshContainerAsserts API asynchronously
func (client *Client) RefreshContainerAssertsWithChan(request *RefreshContainerAssertsRequest) (<-chan *RefreshContainerAssertsResponse, <-chan error) {
	responseChan := make(chan *RefreshContainerAssertsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefreshContainerAsserts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefreshContainerAssertsWithCallback invokes the sas.RefreshContainerAsserts API asynchronously
func (client *Client) RefreshContainerAssertsWithCallback(request *RefreshContainerAssertsRequest, callback func(response *RefreshContainerAssertsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefreshContainerAssertsResponse
		var err error
		defer close(result)
		response, err = client.RefreshContainerAsserts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefreshContainerAssertsRequest is the request struct for api RefreshContainerAsserts
type RefreshContainerAssertsRequest struct {
	*requests.RpcRequest
	SourceIp  string `position:"Query" name:"SourceIp"`
	AssetType string `position:"Query" name:"AssetType"`
}

// RefreshContainerAssertsResponse is the response struct for api RefreshContainerAsserts
type RefreshContainerAssertsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRefreshContainerAssertsRequest creates a request to invoke RefreshContainerAsserts API
func CreateRefreshContainerAssertsRequest() (request *RefreshContainerAssertsRequest) {
	request = &RefreshContainerAssertsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "RefreshContainerAsserts", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRefreshContainerAssertsResponse creates a response to parse from RefreshContainerAsserts response
func CreateRefreshContainerAssertsResponse() (response *RefreshContainerAssertsResponse) {
	response = &RefreshContainerAssertsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
