package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GrantRoles invokes the scsp.GrantRoles API synchronously
func (client *Client) GrantRoles(request *GrantRolesRequest) (response *GrantRolesResponse, err error) {
	response = CreateGrantRolesResponse()
	err = client.DoAction(request, response)
	return
}

// GrantRolesWithChan invokes the scsp.GrantRoles API asynchronously
func (client *Client) GrantRolesWithChan(request *GrantRolesRequest) (<-chan *GrantRolesResponse, <-chan error) {
	responseChan := make(chan *GrantRolesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GrantRoles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GrantRolesWithCallback invokes the scsp.GrantRoles API asynchronously
func (client *Client) GrantRolesWithCallback(request *GrantRolesRequest, callback func(response *GrantRolesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GrantRolesResponse
		var err error
		defer close(result)
		response, err = client.GrantRoles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GrantRolesRequest is the request struct for api GrantRoles
type GrantRolesRequest struct {
	*requests.RpcRequest
	ClientToken string    `position:"Body"`
	InstanceId  string    `position:"Body"`
	AccountName string    `position:"Body"`
	RoleId      *[]string `position:"Body" name:"RoleId"  type:"Repeated"`
	Operator    string    `position:"Body"`
}

// GrantRolesResponse is the response struct for api GrantRoles
type GrantRolesResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateGrantRolesRequest creates a request to invoke GrantRoles API
func CreateGrantRolesRequest() (request *GrantRolesRequest) {
	request = &GrantRolesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "GrantRoles", "", "")
	request.Method = requests.POST
	return
}

// CreateGrantRolesResponse creates a response to parse from GrantRoles response
func CreateGrantRolesResponse() (response *GrantRolesResponse) {
	response = &GrantRolesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
