package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GrantSagInstanceToVbr invokes the smartag.GrantSagInstanceToVbr API synchronously
func (client *Client) GrantSagInstanceToVbr(request *GrantSagInstanceToVbrRequest) (response *GrantSagInstanceToVbrResponse, err error) {
	response = CreateGrantSagInstanceToVbrResponse()
	err = client.DoAction(request, response)
	return
}

// GrantSagInstanceToVbrWithChan invokes the smartag.GrantSagInstanceToVbr API asynchronously
func (client *Client) GrantSagInstanceToVbrWithChan(request *GrantSagInstanceToVbrRequest) (<-chan *GrantSagInstanceToVbrResponse, <-chan error) {
	responseChan := make(chan *GrantSagInstanceToVbrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GrantSagInstanceToVbr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GrantSagInstanceToVbrWithCallback invokes the smartag.GrantSagInstanceToVbr API asynchronously
func (client *Client) GrantSagInstanceToVbrWithCallback(request *GrantSagInstanceToVbrRequest, callback func(response *GrantSagInstanceToVbrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GrantSagInstanceToVbrResponse
		var err error
		defer close(result)
		response, err = client.GrantSagInstanceToVbr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GrantSagInstanceToVbrRequest is the request struct for api GrantSagInstanceToVbr
type GrantSagInstanceToVbrRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	VbrRegionId          string           `position:"Query" name:"VbrRegionId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	VbrInstanceId        string           `position:"Query" name:"VbrInstanceId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	VbrUid               requests.Integer `position:"Query" name:"VbrUid"`
}

// GrantSagInstanceToVbrResponse is the response struct for api GrantSagInstanceToVbr
type GrantSagInstanceToVbrResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	InstanceId string `json:"InstanceId" xml:"InstanceId"`
}

// CreateGrantSagInstanceToVbrRequest creates a request to invoke GrantSagInstanceToVbr API
func CreateGrantSagInstanceToVbrRequest() (request *GrantSagInstanceToVbrRequest) {
	request = &GrantSagInstanceToVbrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "GrantSagInstanceToVbr", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGrantSagInstanceToVbrResponse creates a response to parse from GrantSagInstanceToVbr response
func CreateGrantSagInstanceToVbrResponse() (response *GrantSagInstanceToVbrResponse) {
	response = &GrantSagInstanceToVbrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
