package teambition_aliyun

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateProjectSprint invokes the teambition_aliyun.CreateProjectSprint API synchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/createprojectsprint.html
func (client *Client) CreateProjectSprint(request *CreateProjectSprintRequest) (response *CreateProjectSprintResponse, err error) {
	response = CreateCreateProjectSprintResponse()
	err = client.DoAction(request, response)
	return
}

// CreateProjectSprintWithChan invokes the teambition_aliyun.CreateProjectSprint API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/createprojectsprint.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateProjectSprintWithChan(request *CreateProjectSprintRequest) (<-chan *CreateProjectSprintResponse, <-chan error) {
	responseChan := make(chan *CreateProjectSprintResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateProjectSprint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateProjectSprintWithCallback invokes the teambition_aliyun.CreateProjectSprint API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/createprojectsprint.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateProjectSprintWithCallback(request *CreateProjectSprintRequest, callback func(response *CreateProjectSprintResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateProjectSprintResponse
		var err error
		defer close(result)
		response, err = client.CreateProjectSprint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateProjectSprintRequest is the request struct for api CreateProjectSprint
type CreateProjectSprintRequest struct {
	*requests.RpcRequest
	ExecutorId  string `position:"Body" name:"ExecutorId"`
	Description string `position:"Body" name:"Description"`
	StartDate   string `position:"Body" name:"StartDate"`
	OrgId       string `position:"Body" name:"OrgId"`
	DueDate     string `position:"Body" name:"DueDate"`
	Name        string `position:"Body" name:"Name"`
	ProjectId   string `position:"Body" name:"ProjectId"`
}

// CreateProjectSprintResponse is the response struct for api CreateProjectSprint
type CreateProjectSprintResponse struct {
	*responses.BaseResponse
	Successful bool   `json:"Successful" xml:"Successful"`
	ErrorCode  string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Object     Object `json:"Object" xml:"Object"`
}

// CreateCreateProjectSprintRequest creates a request to invoke CreateProjectSprint API
func CreateCreateProjectSprintRequest() (request *CreateProjectSprintRequest) {
	request = &CreateProjectSprintRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("teambition-aliyun", "2020-02-26", "CreateProjectSprint", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateProjectSprintResponse creates a response to parse from CreateProjectSprint response
func CreateCreateProjectSprintResponse() (response *CreateProjectSprintResponse) {
	response = &CreateProjectSprintResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
