package videoenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ToneSdrVideo invokes the videoenhan.ToneSdrVideo API synchronously
func (client *Client) ToneSdrVideo(request *ToneSdrVideoRequest) (response *ToneSdrVideoResponse, err error) {
	response = CreateToneSdrVideoResponse()
	err = client.DoAction(request, response)
	return
}

// ToneSdrVideoWithChan invokes the videoenhan.ToneSdrVideo API asynchronously
func (client *Client) ToneSdrVideoWithChan(request *ToneSdrVideoRequest) (<-chan *ToneSdrVideoResponse, <-chan error) {
	responseChan := make(chan *ToneSdrVideoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ToneSdrVideo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ToneSdrVideoWithCallback invokes the videoenhan.ToneSdrVideo API asynchronously
func (client *Client) ToneSdrVideoWithCallback(request *ToneSdrVideoRequest, callback func(response *ToneSdrVideoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ToneSdrVideoResponse
		var err error
		defer close(result)
		response, err = client.ToneSdrVideo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ToneSdrVideoRequest is the request struct for api ToneSdrVideo
type ToneSdrVideoRequest struct {
	*requests.RpcRequest
	RecolorModel string           `position:"Body" name:"RecolorModel"`
	Bitrate      requests.Integer `position:"Body" name:"Bitrate"`
	Async        requests.Boolean `position:"Body" name:"Async"`
	VideoURL     string           `position:"Body" name:"VideoURL"`
}

// ToneSdrVideoResponse is the response struct for api ToneSdrVideo
type ToneSdrVideoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateToneSdrVideoRequest creates a request to invoke ToneSdrVideo API
func CreateToneSdrVideoRequest() (request *ToneSdrVideoRequest) {
	request = &ToneSdrVideoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videoenhan", "2020-03-20", "ToneSdrVideo", "videoenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateToneSdrVideoResponse creates a response to parse from ToneSdrVideo response
func CreateToneSdrVideoResponse() (response *ToneSdrVideoResponse) {
	response = &ToneSdrVideoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
