package visionai_poc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PredictCategory invokes the visionai_poc.PredictCategory API synchronously
// api document: https://help.aliyun.com/api/visionai-poc/predictcategory.html
func (client *Client) PredictCategory(request *PredictCategoryRequest) (response *PredictCategoryResponse, err error) {
	response = CreatePredictCategoryResponse()
	err = client.DoAction(request, response)
	return
}

// PredictCategoryWithChan invokes the visionai_poc.PredictCategory API asynchronously
// api document: https://help.aliyun.com/api/visionai-poc/predictcategory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PredictCategoryWithChan(request *PredictCategoryRequest) (<-chan *PredictCategoryResponse, <-chan error) {
	responseChan := make(chan *PredictCategoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PredictCategory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PredictCategoryWithCallback invokes the visionai_poc.PredictCategory API asynchronously
// api document: https://help.aliyun.com/api/visionai-poc/predictcategory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PredictCategoryWithCallback(request *PredictCategoryRequest, callback func(response *PredictCategoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PredictCategoryResponse
		var err error
		defer close(result)
		response, err = client.PredictCategory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PredictCategoryRequest is the request struct for api PredictCategory
type PredictCategoryRequest struct {
	*requests.RpcRequest
	Method   string `position:"Body" name:"Method"`
	ImageUrl string `position:"Body" name:"ImageUrl"`
	Title    string `position:"Body" name:"Title"`
	Url      string `position:"Body" name:"Url"`
}

// PredictCategoryResponse is the response struct for api PredictCategory
type PredictCategoryResponse struct {
	*responses.BaseResponse
	Code     int                       `json:"Code" xml:"Code"`
	Message  string                    `json:"Message" xml:"Message"`
	Success  bool                      `json:"Success" xml:"Success"`
	Response ResponseInPredictCategory `json:"Response" xml:"Response"`
}

// CreatePredictCategoryRequest creates a request to invoke PredictCategory API
func CreatePredictCategoryRequest() (request *PredictCategoryRequest) {
	request = &PredictCategoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("visionai-poc", "2020-04-08", "PredictCategory", "", "")
	return
}

// CreatePredictCategoryResponse creates a response to parse from PredictCategory response
func CreatePredictCategoryResponse() (response *PredictCategoryResponse) {
	response = &PredictCategoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
