package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGroup invokes the vs.CreateGroup API synchronously
func (client *Client) CreateGroup(request *CreateGroupRequest) (response *CreateGroupResponse, err error) {
	response = CreateCreateGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGroupWithChan invokes the vs.CreateGroup API asynchronously
func (client *Client) CreateGroupWithChan(request *CreateGroupRequest) (<-chan *CreateGroupResponse, <-chan error) {
	responseChan := make(chan *CreateGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGroupWithCallback invokes the vs.CreateGroup API asynchronously
func (client *Client) CreateGroupWithCallback(request *CreateGroupRequest, callback func(response *CreateGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGroupRequest is the request struct for api CreateGroup
type CreateGroupRequest struct {
	*requests.RpcRequest
	CaptureVideo     requests.Integer `position:"Query" name:"CaptureVideo"`
	Description      string           `position:"Query" name:"Description"`
	CaptureOssPath   string           `position:"Query" name:"CaptureOssPath"`
	PushDomain       string           `position:"Query" name:"PushDomain"`
	CaptureImage     requests.Integer `position:"Query" name:"CaptureImage"`
	ShowLog          string           `position:"Query" name:"ShowLog"`
	App              string           `position:"Query" name:"App"`
	PlayDomain       string           `position:"Query" name:"PlayDomain"`
	OutProtocol      string           `position:"Query" name:"OutProtocol"`
	CaptureInterval  requests.Integer `position:"Query" name:"CaptureInterval"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	InProtocol       string           `position:"Query" name:"InProtocol"`
	LazyPull         requests.Boolean `position:"Query" name:"LazyPull"`
	Name             string           `position:"Query" name:"Name"`
	Callback         string           `position:"Query" name:"Callback"`
	Region           string           `position:"Query" name:"Region"`
	CaptureOssBucket string           `position:"Query" name:"CaptureOssBucket"`
}

// CreateGroupResponse is the response struct for api CreateGroup
type CreateGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
	GbId      string `json:"GbId" xml:"GbId"`
	GbIp      string `json:"GbIp" xml:"GbIp"`
	GbPort    int64  `json:"GbPort" xml:"GbPort"`
}

// CreateCreateGroupRequest creates a request to invoke CreateGroup API
func CreateCreateGroupRequest() (request *CreateGroupRequest) {
	request = &CreateGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "CreateGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateGroupResponse creates a response to parse from CreateGroup response
func CreateCreateGroupResponse() (response *CreateGroupResponse) {
	response = &CreateGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
