package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAccountStat invokes the vs.DescribeAccountStat API synchronously
func (client *Client) DescribeAccountStat(request *DescribeAccountStatRequest) (response *DescribeAccountStatResponse, err error) {
	response = CreateDescribeAccountStatResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAccountStatWithChan invokes the vs.DescribeAccountStat API asynchronously
func (client *Client) DescribeAccountStatWithChan(request *DescribeAccountStatRequest) (<-chan *DescribeAccountStatResponse, <-chan error) {
	responseChan := make(chan *DescribeAccountStatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAccountStat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAccountStatWithCallback invokes the vs.DescribeAccountStat API asynchronously
func (client *Client) DescribeAccountStatWithCallback(request *DescribeAccountStatRequest, callback func(response *DescribeAccountStatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAccountStatResponse
		var err error
		defer close(result)
		response, err = client.DescribeAccountStat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAccountStatRequest is the request struct for api DescribeAccountStat
type DescribeAccountStatRequest struct {
	*requests.RpcRequest
	Id      string           `position:"Query" name:"Id"`
	ShowLog string           `position:"Query" name:"ShowLog"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeAccountStatResponse is the response struct for api DescribeAccountStat
type DescribeAccountStatResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	Id            string `json:"Id" xml:"Id"`
	GroupNum      int64  `json:"GroupNum" xml:"GroupNum"`
	GroupLimit    int64  `json:"GroupLimit" xml:"GroupLimit"`
	TemplateNum   int64  `json:"TemplateNum" xml:"TemplateNum"`
	TemplateLimit int64  `json:"TemplateLimit" xml:"TemplateLimit"`
}

// CreateDescribeAccountStatRequest creates a request to invoke DescribeAccountStat API
func CreateDescribeAccountStatRequest() (request *DescribeAccountStatRequest) {
	request = &DescribeAccountStatRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeAccountStat", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeAccountStatResponse creates a response to parse from DescribeAccountStat response
func CreateDescribeAccountStatResponse() (response *DescribeAccountStatResponse) {
	response = &DescribeAccountStatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
