/***************************************************************************
                          main.c  -  description
                             -------------------
    begin                : Sun Feb 23 11:20:13 PST 2003
    copyright            : (C) 2003 by Samuel E. Bray
    email                : aristoidaneel@yahoo.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* RCS: */
/* $Id: main.c,v 1.1 2003/03/03 03:16:24 root Exp root $ */
/* $Log: main.c,v $
 * Revision 1.1  2003/03/03 03:16:24  root
 * Initial revision
 * */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>

#include <GL/gl.h>
#include <GL/glu.h>

/* local includes */
#include "joytest.h"
#include "init_quit.h"
#include "input.h"
#include "output.h"

/* Other constants */
const int JS_MAX = 65535;

/* global variables */
static char rcsRev[] = "$Revision: 1.1 $";
int deadZone = 32;
int screenWidth = 640;
int screenHeight = 480;
int screenBPP = 32;
int screenUnitX;
int screenUnitY;
int joyYCenter;
int joyXCenter;
int videoFlags;
int lightCol = 0;
int lightRow = 0;
int pad = 5; /* pad our edges */
int axisPair = 0; /* which sets of axis do we use to controll the XY coords */
int numLights = 0;

GLint textures[2]; /* room for 4 textures */
GLuint base;

SDL_Surface *screen;

int isActive = TRUE;

light lights[NUM_LIGHTS];

aimer_t aimer;

char optionString[]="hVr:d:j:b:";

int cmdOptJ[2] = {FALSE};

struct option options[] =
  {
    {"help", 0, 0, 'h'},
    {"version", 0, 0, 'V'},
    {"res",1,0,'r'},
    {"deadzone",1,0,'d'},
    {"joystick",1,0,'j'},
    {"depth",1,0,'b'},
    {0,0,0,0} /* null termination */
  };

int optch;
/*** End variables & constants ***/


int ProcessEvent (SDL_Event *event, SDL_Joystick *joystick)
{
  int done = FALSE;
  while (SDL_PollEvent (event))
    {
      switch (event->type)
	{
	case SDL_ACTIVEEVENT:
	  if (event->active.gain == 0)
	    isActive = FALSE;
	  else
	    isActive = TRUE;
	  break;
	case SDL_VIDEORESIZE:
	  if((screen=SDL_SetVideoMode(event->resize.w,event->resize.h,screenBPP,videoFlags))==NULL)
	    {
	      Kaboom("Unable to set video mode after resize event.", retVideo);
	    }
	  SetGLWindow(event->resize.w, event->resize.h);
	  screenWidth = event->resize.w;
	  screenHeight = event->resize.h;
	  joyXCenter = screenWidth / 2;
	  joyYCenter = screenHeight / 2;
	  screenUnitX = JS_MAX / screenWidth;
	  screenUnitY = JS_MAX / screenHeight;
	  break;
	case SDL_KEYDOWN:
	  HandleKeyPress (&event->key.keysym, joystick);
	  break;
	case SDL_KEYUP:
	  /* HandleKeyUp (&event->key.keysym); */
	  break;
	case SDL_JOYAXISMOTION:
	  HandleJoyAxis(event);
	  break;
	case SDL_JOYBUTTONDOWN:
	  lights[event->jbutton.button].toggle = !lights[event->jbutton.button].toggle;
	  break;
	case SDL_JOYBUTTONUP:
	  /* This will let us know is we have any "sticky" buttons */
	  /* comment out the below line to make the buttons toggle
	   * on/off with each press */
	  lights[event->jbutton.button].toggle = FALSE;
	  break;
	case SDL_QUIT:
	  fprintf(stdout,"Recived quit event\n");
	  done = TRUE;
	  break;
	default:
	  break;
	}
    }
  return done;
}
/*** End ProcessEvent() ***/

int main(int argc, char **argv)
{
  SDL_Event event;
  SDL_Joystick *joystick;

  /* MMMmmm...command line options...so tasty... */
  extern char *optarg;
  extern int optind;
  extern int opterr;
  
  /* handle command line options */
  while((optch = getopt_long(argc, argv, optionString, options, NULL)) != EOF)
    {
      switch(optch)
	{
	case 0:  /* for handling long only options */
	  break;
	case 'h':
	  PrintHelp();
	  break;
	case 'V':
	  fprintf(stdout,"%s\n",rcsRev);
	  Quit(0);
	  break;
	case 'r':
	  if(optarg)
	    {
	      switch(optarg[0])
		{
		case 'a':
		  screenWidth = 320;
		  screenHeight = 240;
		  fprintf(stdout,"Resolution set to: 320x240\n");
		  break;
		case 'b':
		  screenWidth = 600;
		  screenHeight = 450;
		  fprintf(stdout,"Resolution set to: 600x450\n");
		  break;
		case 'c':
		  screenWidth = 640;
		  screenHeight = 480;
		  fprintf(stdout,"Resolution set to: 640x480\n");
		  break;
		case 'd':
		  screenWidth = 800;
		  screenHeight = 600;
		  fprintf(stdout,"Resolution set to: 800x600\n");
		  break;
		case 'e':
		  screenWidth = 1024;
		  screenHeight = 768;
		  pad = 10;
		  fprintf(stdout,"Resolution set to: 1024x768\n");
		  break;
		default:
		  screenWidth = 640;
		  screenHeight = 480;
		  fprintf(stderr,"Error: Author Lazy: Invalid Resolution!\n");
		  fprintf(stderr,"Setting to default: 640x480 \n");
		  break;
		}
	    }
	  else
	    PrintHelp();
	  break;
	case 'd':
	  if(optarg)
	    {
	      /* We don't want anything over 10% of the max */
	      if(((deadZone=atoi(optarg)) < 1) || (deadZone > 6500))
		{
		  fprintf(stderr,"Invalid deadZone, setting to default: 32\n");
		  deadZone = 32;
		}
	      fprintf(stdout,"DeadZone = %d\n\n",deadZone);
	    }
	  else
	    PrintHelp();
	  break;
	case 'j':
	  if(optarg)
	    {
	      cmdOptJ[0] = TRUE;
	      cmdOptJ[1] = atoi(optarg);
	      /* range is handled in QueryJoystick() */
	    }
	  else
	    PrintHelp();
	  break;
	case 'b':
	  if(optarg)
	    {
	      screenBPP=atoi(optarg);
	      switch(screenBPP)
		{
		case 0:
		  fprintf(stderr,"Huh?\n You want color depth : %d?\n",screenBPP);
		  fprintf(stderr,"Try asking me for help. (-h or --help)\n");
		  Quit(retVideo);
		  break;
		case 8:
		case 15:
		case 16:
		case 24:
		case 32:
		  printf("Color Depth = %d\n", screenBPP);
		  break;
		default:
		  fprintf(stderr,"Huh?\n I don't understand the color depth you wanted : %d?\n",
			  screenBPP);
		  fprintf(stderr,"Try asking me for help. (-h or --help)\n");
		  Quit(retVideo);
		  break;
		}
	    }
	  else
	    PrintHelp();
	  break;
	default:
	  fprintf(stderr,"Huh?\n"); /* being user surly here */
	  Quit(22);
	  break;
	}
    }


  /* init JoyStick */
  joystick = QueryJoyStick();

  /* Determin how many lights needed to represent the buttons */
  numLights=SDL_JoystickNumButtons(joystick);

  /* init other thingies */
  Init();

  while(!ProcessEvent(&event,joystick))
    {
      if(isActive)
	{
	  DrawScreen();
	}
    }

  /* releasing surfaces and joystick */

  fprintf(stdout,"\tReleasing joystick device...");
  SDL_JoystickClose(joystick);
  fprintf(stdout,"done\n");

  fprintf(stdout,"Calling Quit() to finalize close...");
  Quit(MOL);

  fprintf(stdout,"done\nReturning to OS\n");
  return 0;
}
