/***************************************************************************
                          ouput.c  -  description
                             -------------------
    begin                : Sun Feb 23 2003
    copyright            : (C) 2003 by Samuel E. Bray
    email                : aristoidaneel@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* RCS: */
/* $Id: output.c,v 1.1 2003/03/03 03:16:24 root Exp root $ */
/* $Log: output.c,v $
 * Revision 1.1  2003/03/03 03:16:24  root
 * Initial revision
 * */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>

#include <string.h>
#include <stdarg.h>

#include "joytest.h"
#include "output.h"
#include "init_quit.h"


void glPrint(GLint x, GLint y, int set, const char *format, ... )
{
  char text[256];
  va_list ap;
  
  if(format == NULL)
    return;

  /* parse the string for variables */
  va_start(ap, format);
  /* convert symbols to actual numbers */
  vsprintf(text, format, ap);
  va_end(ap);

  /* Did the user choose and invalid char set? */
  if ( set > 1 )
    set = 1;

  /* enable textrue mapping */
  glEnable(GL_TEXTURE_2D);
  
  /* select the texture */
  glBindTexture(GL_TEXTURE_2D, textures[0]);

  /* Disable depth testing */
  glDisable(GL_DEPTH_TEST);

  /* reset the matrix */
  glLoadIdentity();
  /* go to bottom left */
  glTranslated(x, y, 0);
  /* choose the font set (0 or 1) */
  glListBase(base - 32 + (128 * set));
  if(set == 1)
    glScalef(1.5f, 2.0f, 1.0f);
  /* write the text to the screen */
  glCallLists(strlen(text), GL_BYTE, text);

  glDisable(GL_TEXTURE_2D);

  glEnable(GL_DEPTH_TEST);
}

void DrawScreen(void)
{ /* Begin DrawScreen() */

  int i;

  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  glLoadIdentity();

  glDisable(GL_TEXTURE_2D);
  glEnable(GL_DEPTH_TEST);

  glColor3f(0.0f, 0.65f, 0.75f);
  glLineWidth(2.0f);

  /* first draw the background, hash marks first */
  glBegin(GL_LINES);
  {
    /* left, top, hash */
    glVertex2d(screenWidth*0.25f, 0);
    glVertex2d(screenWidth*0.25f, 20);

    /* middle, top, hash */
    glVertex2d(screenWidth*0.5f, 0);
    glVertex2d(screenWidth*0.5f, 35);

    /* right top hash */
    glVertex2d(screenWidth*0.75f, 0);
    glVertex2d(screenWidth*0.75f, 20);

    /* left, bottom hash */
    glVertex2d(screenWidth*0.25f, screenHeight);
    glVertex2d(screenWidth*0.25f, screenHeight - 20);

    /* middle bottom hash */
    glVertex2d(screenWidth*0.5f, screenHeight);
    glVertex2d(screenWidth*0.5f, screenHeight - 35);
    
    /* right bottom hash */
    glVertex2d(screenWidth*0.75f, screenHeight);
    glVertex2d(screenWidth*0.75f, screenHeight - 20);

    /* top left hash */
    glVertex2d(0, screenHeight*0.33f);
    glVertex2d(20, screenHeight*0.33f);

    /* bottom left hash */
    glVertex2d(0, screenHeight*0.66f);
    glVertex2d(20, screenHeight*0.66f);

    /* top right hash */
    glVertex2d(screenWidth, screenHeight*0.33f);
    glVertex2d(screenWidth - 20, screenHeight*0.33f);

    /* botton, right hash */
    glVertex2d(screenWidth, screenHeight*0.66f);
    glVertex2d(screenWidth - 20, screenHeight*0.66f);
  }
  glEnd();


  /* and draw the border box */
  glColor3f(0.0f, 1.0f, 0.0f);
  glLineWidth(4.0f);
 
  glBegin(GL_LINES);
  {
    glVertex2d(0,0);
    glVertex2d(0,screenHeight);

    glVertex2d(0,screenHeight);
    glVertex2d(screenWidth, screenHeight);

    glVertex2d(screenWidth, screenHeight);    
    glVertex2d(screenWidth, 0);

    glVertex2d(screenWidth, 0);
    glVertex2d(0,0);

  }
  glEnd();

  glEnable(GL_TEXTURE_2D);
  glDisable(GL_DEPTH_TEST);
  glBindTexture(GL_TEXTURE_2D, textures[1]);


  for(i=0;i<numLights;i++)
    {
      /* if the light[i] is on select color red */
      if(lights[i].toggle)
	glColor3f(1.0f, 1.0f, 0.0f);
      /* otherwise select color blue */
      else
	glColor3f(0.0f, 1.0f, 1.0f);

      /* draw the light */
      glLoadIdentity();
      glTranslatef((float)lights[i].x_offset, (float)lights[i].y_offset, 0.0f);
      
      glBegin(GL_QUADS);
      {
	glTexCoord2f(0.0f, 0.0f);
	glVertex2i(0, 0);

	glTexCoord2f(0.0, 1.0f);
	glVertex2i(0, 64);

	glTexCoord2f(1.0f, 1.0f);
	glVertex2i(64, 64);

	glTexCoord2f(1.0f, 0.0f);
	glVertex2i(64, 0);
      }
      glEnd();
    }

  glColor3f(1.0f, 1.0f, 0.0f); /* set color */
  
  /* print useful information to the screen */
  glPrint(screenWidth*0.25f, screenHeight*0.05, 0, "Axis Pair: %d", axisPair); 

  glPrint(screenWidth*0.25f, 
	  screenHeight*0.1, 
	  0, 
	  "X = %d, Y = %d", 
	  aimer.x, 
	  aimer.y);
  

  glLoadIdentity();
  glEnable(GL_DEPTH_TEST);
  glDisable(GL_TEXTURE_2D);

  glColor3f(1.0f, 1.0f, 1.0f);
  glLineWidth(1.0f);

  glTranslatef((float)(aimer.x - 32), (float)(aimer.y - 32), 0.0f);

  /* draw the aim reticle */
  glBegin(GL_LINES);
  {
    /* top mark */
    glVertex2i(32, 0);
    glVertex2i(32, 20);

    /* left mark */
    glVertex2i(0, 32);
    glVertex2i(20, 32);

    /* right mark */
    glVertex2i(44, 32);
    glVertex2i(64, 32);

    /* bottom mark */
    glVertex2i(32, 44);
    glVertex2i(32, 64);
  }
  glEnd();

  SDL_GL_SwapBuffers();

}
/*** End DrawScreen() ***/


void PrintHelp(void)
{
  fprintf(stdout,"SDLJoytest : Copyright (C) 2003 Samuel E. Bray\n");
  fprintf(stdout,"License: GPL v2.0\n See the file: COPYING in source package.\n");
  fprintf(stdout,"\nUsage: SDLJoytest [options[args]]\n");
  fprintf(stdout,"Options:\n");
  fprintf(stdout,"\tSelect Resolution -> -r, --res ResOption\n");
  fprintf(stdout,"\t->\ta : 320x240\n");
  fprintf(stdout,"\t->\tb : 600x450 (For PS2 & XBox Linux & other NTSC output)\n");
  fprintf(stdout,"\t->\tc : 640x480 (default)\n");
  fprintf(stdout,"\t->\td : 800x600\n");
  fprintf(stdout,"\t->\te : 1024x768\n");
  fprintf(stdout,"\tSet DeadZone -> -d, --deadzone (1-3200) (up to 5%%)\n");
  fprintf(stdout,"\tSet Joystick -> -j, --joystick (0-X, X = last joystick on system)\n");
  fprintf(stdout,"\tSet Color Depth -> -b, --depth (8,15,16,24,32)\n");
  fprintf(stdout,"\tSee Revision History -> -V, --version\n");
  fprintf(stdout,"\tHelp -> -h, --help\n\n");
  Quit(retOK);
}
/*** End PrintHelp() ***/
