# bitmask-core

`bitmask-core` is a library to handle bootstrap for a LEAP provider in an unified way.

**Bitmask-core** will be code shared by desktop and mobile apps that will unify the discovery process. The major architectural change in bitmask-core is that it generates API clients automatically from the OpenAPI spec generated by latest [menshen](https://0xacab.org/leap/menshen/-/blob/main/api/swagger.yaml?ref_type=heads). bitmask-core implements a local key-value store to persist configuration (private bridges, etc). An interface to replace native stores will be needed.

## Features

* a go library that exports functions to get gateways, bridges, VPN credentials and more from [menshen](https://0xacab.org/leap/menshen/) (the backend)
* For the initial boostrap, DoH (DNS over HTTPs) or an arbitrary SOCKS5 proxy (for Tor/snowflake)
* Handle a local registry of known introducers. An introducer is an obfuscation proxy used to communicate with menshen, the service configuration API. 
* Handle a local registry of private bridges.


# Persistent config

You can use `$HOME/.bitmaskcfg` for some common settings that will be picked by default:

```
❯ cat ~/.bitmaskcfg
host: menshen.example.org
#bridge: bridge-1
#introducer: littleintroducer
```

# Android library

You can create the Android library of bitmask-core by running:
```
make mobileclient
```

If you don't want to bother installing Android NDK, you can also build the library in a Docker image containing the Android development environment from our container registry:
``` shell
sudo docker run --rm -w /bitmask-core -it -v $(pwd):/bitmask-core -t registry.0xacab.org/leap/bitmask_android/android-ndk:latest make mobileclient
```

If everything works you will get `bitmask-core.aar` and `bitmask-core-sources.jar` in the project root.

# Maintenance

For synchronized changes in the api, you need to install [swag](https://github.com/swaggo/swag) and use `make` to generate the Swagger client:

```
go install github.com/swaggo/swag/cmd/swag@latest
make client
```

# Tests
Use `make test` to run the unit tests.

Use `make integration_test` to run the integration tests. For the integration tests, a local menshen container gets started (see tests/docker-compose-local.yml).

In order to add new intergration tests, just add a new golang unit test that contains `Integration` in its function name, for example
```
func TestIntegrationGetService(t *testing.T) {
  ...
}
```

The CI runs the unit and integration tests.