-- -*-Sql-*- mode (to keep my emacs happy)
--
-- API Package Body for Location_Qualifier_Assoc.
--
-- Scaffold auto-generated by gen-api.pl. gen-api.pl is
-- Copyright 2002-2003 Genomics Institute of the Novartis Research Foundation
-- Copyright 2002-2008 Hilmar Lapp
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--

CREATE OR REPLACE
PACKAGE BODY LocTrmA IS

CURSOR LocTrmA_c (
		LocTrmA_LOC_OID	IN SG_LOCATION_QUALIFIER_ASSOC.LOC_OID%TYPE,
		LocTrmA_TRM_OID	IN SG_LOCATION_QUALIFIER_ASSOC.TRM_OID%TYPE)
RETURN SG_LOCATION_QUALIFIER_ASSOC%ROWTYPE IS
	SELECT t.* FROM SG_LOCATION_QUALIFIER_ASSOC t
	WHERE
		t.Loc_Oid = LocTrmA_LOC_OID
	AND     t.Trm_Oid = LocTrmA_TRM_OID
	;

FUNCTION get_oid(
		LOC_OID	IN SG_LOCATION_QUALIFIER_ASSOC.LOC_OID%TYPE DEFAULT NULL,
		TRM_OID	IN SG_LOCATION_QUALIFIER_ASSOC.TRM_OID%TYPE DEFAULT NULL,
		LocTrmA_VALUE	IN SG_LOCATION_QUALIFIER_ASSOC.VALUE%TYPE DEFAULT NULL,
		Trm_NAME	IN SG_TERM.NAME%TYPE DEFAULT NULL,
		ONT_OID	IN SG_TERM.ONT_OID%TYPE DEFAULT NULL,
		ONT_NAME	IN SG_ONTOLOGY.NAME%TYPE DEFAULT NULL,
		Trm_IDENTIFIER	IN SG_TERM.IDENTIFIER%TYPE DEFAULT NULL,
		Loc_FEA_OID	IN SG_LOCATION.FEA_OID%TYPE DEFAULT NULL,
		Loc_RANK	IN SG_LOCATION.RANK%TYPE DEFAULT NULL,
		do_DML		IN NUMBER DEFAULT BSStd.DML_NO)
RETURN INTEGER
IS
	pk	INTEGER DEFAULT NULL;
	LocTrmA_row LocTrmA_c%ROWTYPE;
	TRM_OID_	SG_TERM.OID%TYPE DEFAULT TRM_OID;
	LOC_OID_	SG_LOCATION.OID%TYPE DEFAULT LOC_OID;
BEGIN
	-- look up SG_SEQFEATURE_LOCATION
	IF (LOC_OID_ IS NULL) THEN
		LOC_OID_ := Loc.get_oid(
				FEA_OID => Loc_FEA_OID,
				Loc_RANK => Loc_RANK);
	END IF;
	-- look up SG_TERM
	IF (TRM_OID_ IS NULL) THEN
		TRM_OID_ := Trm.get_oid(
				Trm_NAME => Trm_NAME,
				ONT_OID => ONT_OID,
				ONT_NAME => ONT_NAME,
				Trm_IDENTIFIER => Trm_IDENTIFIER);
	END IF;
	-- do the look up
	FOR LocTrmA_row IN LocTrmA_c (Loc_OID_, Trm_OID_) LOOP
        	pk := 1;
	END LOOP;
	-- insert if requested (no update since no UK)
	IF (do_DML = BSStd.DML_I) OR (do_DML = BSStd.DML_UI) THEN
	    	-- look up foreign keys if not provided:
		-- look up SG_TERM successful?
		IF (TRM_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Trm <' || Trm_NAME || '|' || ONT_OID || '|' || ONT_NAME || '|' || Trm_IDENTIFIER || '>');
		END IF;
		-- look up SG_LOCATION successful?
		IF (LOC_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Loc <' || Loc_FEA_OID || '|' || Loc_RANK || '>');
		END IF;
	    	-- insert the record and obtain the primary key
	    	pk := do_insert(
			LOC_OID => LOC_OID_,
			TRM_OID => TRM_OID_,
			VALUE => LocTrmA_VALUE);
	ELSIF (do_DML = BSStd.DML_U) OR (do_DML = BSStd.DML_UI) THEN
	        -- update the record (note that not provided FKs will not
		-- be changed nor looked up)
		do_update(
		        LocTrmA_LOC_OID => LOC_OID_,
			LocTrmA_TRM_OID => TRM_OID_,
			LocTrmA_VALUE => LocTrmA_VALUE);
	END IF;
	-- return the primary key
	RETURN pk;
END;

FUNCTION do_insert(
		LOC_OID	IN SG_LOCATION_QUALIFIER_ASSOC.LOC_OID%TYPE,
		TRM_OID	IN SG_LOCATION_QUALIFIER_ASSOC.TRM_OID%TYPE,
		VALUE	IN SG_LOCATION_QUALIFIER_ASSOC.VALUE%TYPE)
RETURN INTEGER
IS
BEGIN
	-- insert the record
	INSERT INTO SG_LOCATION_QUALIFIER_ASSOC (
		LOC_OID,
		TRM_OID,
		VALUE)
	VALUES (LOC_OID,
		TRM_OID,
		VALUE)
	;
	-- return TRUE
	RETURN 1;
END;

PROCEDURE do_update(
		LocTrmA_LOC_OID	IN SG_LOCATION_QUALIFIER_ASSOC.LOC_OID%TYPE,
		LocTrmA_TRM_OID	IN SG_LOCATION_QUALIFIER_ASSOC.TRM_OID%TYPE,
		LocTrmA_VALUE	IN SG_LOCATION_QUALIFIER_ASSOC.VALUE%TYPE)
IS
BEGIN
	-- update the record (and leave attributes passed as NULL untouched)
	UPDATE SG_LOCATION_QUALIFIER_ASSOC
	SET
		VALUE = NVL(LocTrmA_VALUE, VALUE)
	WHERE	LOC_OID = LocTrmA_LOC_OID
	AND	TRM_OID = LocTrmA_TRM_OID
	;
END;

END LocTrmA;
/

