/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands.projects;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import okhttp3.RequestBody;
import org.rundeck.client.api.RequestFailed;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.api.model.ACLPolicy;
import org.rundeck.client.api.model.ACLPolicyItem;
import org.rundeck.client.api.model.ACLPolicyValidation;
import org.rundeck.client.tool.CommandOutput;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.ProjectInput;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.extension.RdTool;
import org.rundeck.client.tool.options.ACLOutputFormatOption;
import org.rundeck.client.tool.options.ProjectRequiredNameOptions;
import org.rundeck.client.tool.util.Colorz;
import org.rundeck.client.util.Client;
import org.rundeck.client.util.Format;
import org.rundeck.client.util.ServiceClient;
import picocli.CommandLine;
import retrofit2.Call;
import retrofit2.Response;

@CommandLine.Command(description={"Manage Project ACLs"}, name="acls")
public class ACLs
extends BaseCommand {
    private String getProjectName(ProjectInput input) throws InputError {
        return this.getRdTool().projectOrEnv(input);
    }

    @CommandLine.Command(description={"list project acls"})
    public void list(@CommandLine.Mixin ACLOutputFormatOption outputOptions, @CommandLine.Mixin ProjectRequiredNameOptions projectRequiredNameOptions) throws IOException, InputError {
        String project = this.getProjectName(projectRequiredNameOptions);
        ACLPolicyItem items = (ACLPolicyItem)this.apiCall(api -> api.listAcls(project));
        ACLs.outputListResult(outputOptions, this.getRdOutput(), items, String.format("project %s", project));
    }

    public static void outputListResult(ACLOutputFormatOption options, CommandOutput output, ACLPolicyItem aclList, String ident) {
        output.info(String.format("%d ACL Policy items for %s", aclList.getResources().size(), ident));
        if (options.isVerbose()) {
            output.output(aclList.getResources().stream().map(ACLPolicyItem::toMap).collect(Collectors.toList()));
            return;
        }
        Function<ACLPolicyItem, Object> outformat = options.getOutputFormat() != null ? Format.formatter(options.getOutputFormat(), ACLPolicyItem::toMap, "%", "") : ACLPolicyItem::getPath;
        output.output(aclList.getResources().stream().map(outformat).collect(Collectors.toList()));
    }

    @CommandLine.Command(description={"get a project ACL definition"})
    public void get(@CommandLine.Mixin ACLNameRequiredOptions aclNameOptions, @CommandLine.Mixin ProjectRequiredNameOptions projectNameOptions) throws IOException, InputError {
        String project = this.getProjectName(projectNameOptions);
        ACLPolicy aclPolicy = (ACLPolicy)this.apiCall(api -> api.getAclPolicy(project, aclNameOptions.name));
        ACLs.outputPolicyResult(this.getRdOutput(), aclPolicy);
    }

    public static void outputPolicyResult(CommandOutput output, ACLPolicy aclPolicy) {
        output.output(aclPolicy.getContents());
    }

    @CommandLine.Command(description={"Upload a project ACL definition. [@|red DEPRECATED|@: use @|bold rd projects acls update|@]"}, hidden=true)
    @Deprecated
    public void upload(@CommandLine.Mixin ACLNameRequiredOptions nameOptions, @CommandLine.Mixin ACLFileOptions fileOptions, @CommandLine.Mixin ProjectRequiredNameOptions projectNameOptions) throws IOException, InputError {
        this.getRdOutput().info("@|faint rd projects acls upload command is deprecated, use: rd projects acls update|@");
        this.update(nameOptions, fileOptions, projectNameOptions);
    }

    @CommandLine.Command(description={"Upload a project ACL definition"})
    public void update(@CommandLine.Mixin ACLNameRequiredOptions nameOptions, @CommandLine.Mixin ACLFileOptions fileOptions, @CommandLine.Mixin ProjectRequiredNameOptions projectNameOptions) throws IOException, InputError {
        String project = this.getProjectName(projectNameOptions);
        ACLPolicy aclPolicy = ACLs.performACLModify(fileOptions, (body, api) -> api.updateAclPolicy(project, nameOptions.getName(), (RequestBody)body), this.getRdTool(), this.getRdOutput());
        ACLs.outputPolicyResult(this.getRdOutput(), aclPolicy);
    }

    @CommandLine.Command(description={"Create a project ACL definition"})
    public void create(@CommandLine.Mixin ACLNameRequiredOptions nameOptions, @CommandLine.Mixin ACLFileOptions fileOptions, @CommandLine.Mixin ProjectRequiredNameOptions projectNameOptions) throws IOException, InputError {
        String project = this.getProjectName(projectNameOptions);
        ACLPolicy aclPolicy = ACLs.performACLModify(fileOptions, (body, api) -> api.createAclPolicy(project, nameOptions.getName(), (RequestBody)body), this.getRdTool(), this.getRdOutput());
        ACLs.outputPolicyResult(this.getRdOutput(), aclPolicy);
    }

    public static ACLPolicy performACLModify(ACLFileOptions options, BiFunction<RequestBody, RundeckApi, Call<ACLPolicy>> func, RdTool rdTool, CommandOutput output) throws IOException, InputError {
        File input = options.getFile();
        if (!input.canRead() || !input.isFile()) {
            throw new InputError(String.format("File is not readable or does not exist: %s", input));
        }
        RequestBody requestBody = RequestBody.create(input, Client.MEDIA_TYPE_YAML);
        ServiceClient.WithErrorResponse<ACLPolicy> execute2 = rdTool.apiWithErrorResponseDowngradable(api -> (Call)func.apply(requestBody, (RundeckApi)api));
        ACLs.checkValidationError(output, rdTool.getClient(), execute2, input.getAbsolutePath(), rdTool.getAppConfig().isAnsiEnabled());
        return rdTool.getClient().checkError(execute2);
    }

    private static void checkValidationError(CommandOutput output, ServiceClient<RundeckApi> client, ServiceClient.WithErrorResponse<ACLPolicy> errorResponse, String filename, boolean colorize) throws IOException {
        Response<ACLPolicy> response = errorResponse.getResponse();
        if (errorResponse.isError400()) {
            ACLPolicyValidation error = client.readError(errorResponse.getErrorBody(), ACLPolicyValidation.class, Client.MEDIA_TYPE_JSON);
            if (null != error) {
                Optional<Map<String, Object>> validationData = Optional.ofNullable(error.toMap());
                validationData.ifPresent(map -> {
                    output.error("ACL Policy Validation failed for the file: ");
                    output.output(filename);
                    output.output(colorize ? Colorz.colorizeMapRecurse(map, "yellow") : map);
                });
                if (!validationData.isPresent() && "true".equals(error.errorString)) {
                    output.error("Invalid Request:");
                    client.reportApiError(error);
                }
            }
            throw new RequestFailed(String.format("ACLPolicy Validation failed: (error: %d %s)", response.code(), response.message()), response.code(), response.message());
        }
    }

    @CommandLine.Command(description={"Delete a project ACL definition"})
    public void delete(@CommandLine.Mixin ACLNameRequiredOptions options, @CommandLine.Mixin ProjectRequiredNameOptions projectRequiredNameOptions) throws IOException, InputError {
        String project = this.getProjectName(projectRequiredNameOptions);
        this.apiCall(api -> api.deleteAclPolicy(project, options.getName()));
        this.getRdOutput().info(String.format("Deleted ACL Policy for %s: %s", project, options.getName()));
    }

    public static class ACLFileOptions {
        @CommandLine.Option(names={"-f", "--file"}, description={"ACLPolicy file to upload"}, required=true)
        File file;

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }
    }

    public static class ACLNameRequiredOptions {
        @CommandLine.Option(names={"-n", "--name"}, description={"name of the aclpolicy file"}, required=true)
        String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class ACLNameOptions {
        @CommandLine.Option(names={"-n", "--name"}, description={"name of the aclpolicy file"})
        String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

