/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.data;

import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import jrm.profile.data.Container;
import jrm.profile.data.Disk;
import jrm.profile.data.Rom;
import jrm.profile.data.Sample;
import org.apache.commons.io.FilenameUtils;

public class Entry
implements Serializable {
    public String file;
    public long size = 0L;
    public long modified = 0L;
    public String crc = null;
    public String sha1 = null;
    public String md5 = null;
    public Container parent = null;
    public Type type = Type.UNK;

    public Entry(String file) {
        this.file = file;
        String ext = FilenameUtils.getExtension(file);
        switch (ext.toLowerCase()) {
            case "chd": {
                this.type = Type.CHD;
            }
        }
    }

    public Entry(String file, BasicFileAttributes attr) {
        this(file);
        this.size = attr.size();
        this.modified = attr.lastModifiedTime().toMillis();
    }

    public String getName() {
        Path path = Paths.get(this.file, new String[0]);
        if (this.parent.getType() == Container.Type.DIR) {
            return this.parent.file.toPath().relativize(path).toString().replace('\\', '/');
        }
        if (this.type == Type.CHD) {
            return path.getFileName().toString();
        }
        return path.subpath(0, path.getNameCount()).toString().replace('\\', '/');
    }

    public boolean equals(Object obj) {
        if (obj instanceof Entry) {
            if (((Entry)obj).sha1 != null && this.sha1 != null) {
                return ((Entry)obj).sha1.equals(this.sha1);
            }
            if (((Entry)obj).md5 != null && this.md5 != null) {
                return ((Entry)obj).md5.equals(this.md5);
            }
            if (((Entry)obj).crc != null && this.crc != null) {
                return ((Entry)obj).crc.equals(this.crc) && ((Entry)obj).size == this.size;
            }
            if (((Entry)obj).modified != 0L && this.modified != 0L) {
                return ((Entry)obj).modified == this.modified && ((Entry)obj).size == this.size;
            }
        } else if (obj instanceof Rom) {
            if (((Rom)obj).sha1 != null && this.sha1 != null) {
                return ((Rom)obj).sha1.equals(this.sha1);
            }
            if (((Rom)obj).md5 != null && this.md5 != null) {
                return ((Rom)obj).md5.equals(this.md5);
            }
            if (((Rom)obj).crc != null && this.crc != null) {
                return ((Rom)obj).crc.equals(this.crc) && ((Rom)obj).size == this.size;
            }
        } else if (obj instanceof Disk) {
            if (((Disk)obj).sha1 != null && this.sha1 != null) {
                return ((Disk)obj).sha1.equals(this.sha1);
            }
            if (((Disk)obj).md5 != null && this.md5 != null) {
                return ((Disk)obj).md5.equals(this.md5);
            }
        } else if (obj instanceof Sample) {
            return ((Sample)obj).getNormalizedName().equals(this.getName());
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.parent.file + "::" + this.file;
    }

    public static enum Type {
        UNK,
        CHD;

    }
}

