/*
 * Copyright (C) 2002-2008 The Warp Rogue Team
 * Part of the Warp Rogue Project
 *
 * This software is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License.
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY.
 *
 * See the license.txt file for more details.
 */

/*
 * Module: AI Tactics
 */

#include "wrogue.h"



/* Tactic names
 */
static const char TacticName[MAX_TACTICS][TACTIC_NAME_SIZE] = {

        "Patrol",
        "Guard",

        "Plan A",
        "Hold position",
        "Stay close"
};



/* Returns a list which contains the names of all available tactics
 */
LIST * tactics_list(void)
{
        LIST *list = list_new();
        TACTIC tactic;

        /* build list */
        iterate_over_tactics(tactic) {

                if (tactic >= TACTIC_PLAN_A) 
                        list_add(list, (void *)TacticName[tactic]);
        }

        /* return list */
        return list;
}



/* Returns the name of a tactic
 */
const char * tactic_name(TACTIC tactic)
{
        return TacticName[tactic];
}



/* Name -> tactic
 */
TACTIC name_to_tactic(const char *name)
{
        TACTIC tactic;

        iterate_over_tactics(tactic) {

                if (strings_equal(name, TacticName[tactic])) {

                        return tactic;
                }
        }

        die("*** CORE ERROR *** invalid tactic: %s", name);

        /* never reached */
        return TACTIC_NIL;
}

