//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uisearchcontrollerscopebaractivation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UISearchControllerScopeBarActivation(pub NSInteger);
impl UISearchControllerScopeBarActivation {
    /// System-defined automatic showing and hiding of the scope bar
    #[doc(alias = "UISearchControllerScopeBarActivationAutomatic")]
    pub const Automatic: Self = Self(0);
    /// Showing and hiding the scope bar will be controlled by client code through the `showsScopeBar` API on the UISearchController's `searchBar`
    #[doc(alias = "UISearchControllerScopeBarActivationManual")]
    pub const Manual: Self = Self(1);
    /// The search controller shows the scope bar when typing begins in the search field, and hides it when search is cancelled
    #[doc(alias = "UISearchControllerScopeBarActivationOnTextEntry")]
    pub const OnTextEntry: Self = Self(2);
    /// The search controller shows the scope bar when search becomes active, and hides it when search is cancelled
    #[doc(alias = "UISearchControllerScopeBarActivationOnSearchActivation")]
    pub const OnSearchActivation: Self = Self(3);
}

unsafe impl Encode for UISearchControllerScopeBarActivation {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UISearchControllerScopeBarActivation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uisearchcontrollerdelegate?language=objc)
    pub unsafe trait UISearchControllerDelegate: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
        #[optional]
        #[unsafe(method(willPresentSearchController:))]
        #[unsafe(method_family = none)]
        fn willPresentSearchController(&self, search_controller: &UISearchController);

        #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
        #[optional]
        #[unsafe(method(didPresentSearchController:))]
        #[unsafe(method_family = none)]
        fn didPresentSearchController(&self, search_controller: &UISearchController);

        #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
        #[optional]
        #[unsafe(method(willDismissSearchController:))]
        #[unsafe(method_family = none)]
        fn willDismissSearchController(&self, search_controller: &UISearchController);

        #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
        #[optional]
        #[unsafe(method(didDismissSearchController:))]
        #[unsafe(method_family = none)]
        fn didDismissSearchController(&self, search_controller: &UISearchController);

        #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
        #[optional]
        #[unsafe(method(presentSearchController:))]
        #[unsafe(method_family = none)]
        fn presentSearchController(&self, search_controller: &UISearchController);

        #[cfg(all(
            feature = "UINavigationItem",
            feature = "UIResponder",
            feature = "UIViewController"
        ))]
        #[optional]
        #[unsafe(method(searchController:willChangeToSearchBarPlacement:))]
        #[unsafe(method_family = none)]
        fn searchController_willChangeToSearchBarPlacement(
            &self,
            search_controller: &UISearchController,
            new_placement: UINavigationItemSearchBarPlacement,
        );

        #[cfg(all(
            feature = "UINavigationItem",
            feature = "UIResponder",
            feature = "UIViewController"
        ))]
        #[optional]
        #[unsafe(method(searchController:didChangeFromSearchBarPlacement:))]
        #[unsafe(method_family = none)]
        fn searchController_didChangeFromSearchBarPlacement(
            &self,
            search_controller: &UISearchController,
            previous_placement: UINavigationItemSearchBarPlacement,
        );
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uisearchresultsupdating?language=objc)
    pub unsafe trait UISearchResultsUpdating: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
        #[unsafe(method(updateSearchResultsForSearchController:))]
        #[unsafe(method_family = none)]
        fn updateSearchResultsForSearchController(&self, search_controller: &UISearchController);

        #[cfg(all(
            feature = "UIResponder",
            feature = "UISearchSuggestion",
            feature = "UIViewController"
        ))]
        #[optional]
        #[unsafe(method(updateSearchResultsForSearchController:selectingSearchSuggestion:))]
        #[unsafe(method_family = none)]
        fn updateSearchResultsForSearchController_selectingSearchSuggestion(
            &self,
            search_controller: &UISearchController,
            search_suggestion: &ProtocolObject<dyn UISearchSuggestion>,
        );
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uisearchcontroller?language=objc)
    #[unsafe(super(UIViewController, UIResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
    pub struct UISearchController;
);

#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
extern_conformance!(
    unsafe impl NSCoding for UISearchController {}
);

#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for UISearchController {}
);

#[cfg(all(
    feature = "UIAppearance",
    feature = "UIResponder",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl UIAppearanceContainer for UISearchController {}
);

#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
extern_conformance!(
    unsafe impl UIContentContainer for UISearchController {}
);

#[cfg(all(
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl UIFocusEnvironment for UISearchController {}
);

#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
extern_conformance!(
    unsafe impl UIResponderStandardEditActions for UISearchController {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UITraitCollection",
    feature = "UIViewController"
))]
extern_conformance!(
    unsafe impl UITraitEnvironment for UISearchController {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UIViewController",
    feature = "UIViewControllerTransitioning"
))]
extern_conformance!(
    unsafe impl UIViewControllerAnimatedTransitioning for UISearchController {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UIViewController",
    feature = "UIViewControllerTransitioning"
))]
extern_conformance!(
    unsafe impl UIViewControllerTransitioningDelegate for UISearchController {}
);

#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
impl UISearchController {
    extern_methods!(
        #[unsafe(method(initWithSearchResultsController:))]
        #[unsafe(method_family = init)]
        pub fn initWithSearchResultsController(
            this: Allocated<Self>,
            search_results_controller: Option<&UIViewController>,
        ) -> Retained<Self>;

        #[unsafe(method(initWithNibName:bundle:))]
        #[unsafe(method_family = init)]
        pub fn initWithNibName_bundle(
            this: Allocated<Self>,
            nib_name_or_nil: Option<&NSString>,
            nib_bundle_or_nil: Option<&NSBundle>,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(searchResultsUpdater))]
        #[unsafe(method_family = none)]
        pub fn searchResultsUpdater(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn UISearchResultsUpdating>>>;

        /// Setter for [`searchResultsUpdater`][Self::searchResultsUpdater].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setSearchResultsUpdater:))]
        #[unsafe(method_family = none)]
        pub fn setSearchResultsUpdater(
            &self,
            search_results_updater: Option<&ProtocolObject<dyn UISearchResultsUpdating>>,
        );

        #[unsafe(method(isActive))]
        #[unsafe(method_family = none)]
        pub fn isActive(&self) -> bool;

        /// Setter for [`isActive`][Self::isActive].
        #[unsafe(method(setActive:))]
        #[unsafe(method_family = none)]
        pub fn setActive(&self, active: bool);

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(&self) -> Option<Retained<ProtocolObject<dyn UISearchControllerDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn UISearchControllerDelegate>>,
        );

        #[deprecated]
        #[unsafe(method(dimsBackgroundDuringPresentation))]
        #[unsafe(method_family = none)]
        pub fn dimsBackgroundDuringPresentation(&self) -> bool;

        /// Setter for [`dimsBackgroundDuringPresentation`][Self::dimsBackgroundDuringPresentation].
        #[deprecated]
        #[unsafe(method(setDimsBackgroundDuringPresentation:))]
        #[unsafe(method_family = none)]
        pub fn setDimsBackgroundDuringPresentation(
            &self,
            dims_background_during_presentation: bool,
        );

        #[unsafe(method(obscuresBackgroundDuringPresentation))]
        #[unsafe(method_family = none)]
        pub fn obscuresBackgroundDuringPresentation(&self) -> bool;

        /// Setter for [`obscuresBackgroundDuringPresentation`][Self::obscuresBackgroundDuringPresentation].
        #[unsafe(method(setObscuresBackgroundDuringPresentation:))]
        #[unsafe(method_family = none)]
        pub fn setObscuresBackgroundDuringPresentation(
            &self,
            obscures_background_during_presentation: bool,
        );

        /// Default is `YES` for apps linked before iOS 26.0, other than on MacCatalyst, where the default is `NO`.
        /// On iOS 26.0 for apps linked on iOS 26.0 and later, the value is determined by context unless directly set through the API. The default remains `NO` on MacCatalyst.
        #[unsafe(method(hidesNavigationBarDuringPresentation))]
        #[unsafe(method_family = none)]
        pub fn hidesNavigationBarDuringPresentation(&self) -> bool;

        /// Setter for [`hidesNavigationBarDuringPresentation`][Self::hidesNavigationBarDuringPresentation].
        #[unsafe(method(setHidesNavigationBarDuringPresentation:))]
        #[unsafe(method_family = none)]
        pub fn setHidesNavigationBarDuringPresentation(
            &self,
            hides_navigation_bar_during_presentation: bool,
        );

        #[unsafe(method(searchResultsController))]
        #[unsafe(method_family = none)]
        pub fn searchResultsController(&self) -> Option<Retained<UIViewController>>;

        #[cfg(all(feature = "UISearchBar", feature = "UIView"))]
        #[unsafe(method(searchBar))]
        #[unsafe(method_family = none)]
        pub fn searchBar(&self) -> Retained<UISearchBar>;

        #[cfg(feature = "UINavigationItem")]
        #[unsafe(method(searchBarPlacement))]
        #[unsafe(method_family = none)]
        pub fn searchBarPlacement(&self) -> UINavigationItemSearchBarPlacement;

        #[unsafe(method(automaticallyShowsSearchResultsController))]
        #[unsafe(method_family = none)]
        pub fn automaticallyShowsSearchResultsController(&self) -> bool;

        /// Setter for [`automaticallyShowsSearchResultsController`][Self::automaticallyShowsSearchResultsController].
        #[unsafe(method(setAutomaticallyShowsSearchResultsController:))]
        #[unsafe(method_family = none)]
        pub fn setAutomaticallyShowsSearchResultsController(
            &self,
            automatically_shows_search_results_controller: bool,
        );

        #[unsafe(method(showsSearchResultsController))]
        #[unsafe(method_family = none)]
        pub fn showsSearchResultsController(&self) -> bool;

        /// Setter for [`showsSearchResultsController`][Self::showsSearchResultsController].
        #[unsafe(method(setShowsSearchResultsController:))]
        #[unsafe(method_family = none)]
        pub fn setShowsSearchResultsController(&self, shows_search_results_controller: bool);

        #[unsafe(method(automaticallyShowsCancelButton))]
        #[unsafe(method_family = none)]
        pub fn automaticallyShowsCancelButton(&self) -> bool;

        /// Setter for [`automaticallyShowsCancelButton`][Self::automaticallyShowsCancelButton].
        #[unsafe(method(setAutomaticallyShowsCancelButton:))]
        #[unsafe(method_family = none)]
        pub fn setAutomaticallyShowsCancelButton(&self, automatically_shows_cancel_button: bool);

        #[deprecated = "Use scopeBarActivation instead"]
        #[unsafe(method(automaticallyShowsScopeBar))]
        #[unsafe(method_family = none)]
        pub fn automaticallyShowsScopeBar(&self) -> bool;

        /// Setter for [`automaticallyShowsScopeBar`][Self::automaticallyShowsScopeBar].
        #[deprecated = "Use scopeBarActivation instead"]
        #[unsafe(method(setAutomaticallyShowsScopeBar:))]
        #[unsafe(method_family = none)]
        pub fn setAutomaticallyShowsScopeBar(&self, automatically_shows_scope_bar: bool);

        /// Controls if and when the UISearchController shows and hides the scope bar
        /// However, UISearchBar will not show the scope bar if `scopeButtonTitles` contains fewer than two titles
        /// Defaults to `UISearchControllerScopeBarActivationAutomatic`
        /// `UISearchControllerScopeBarActivationAutomatic` is equivalent to earlier `automaticallyShowsScopeBar == YES`
        /// `UISearchControllerScopeBarActivationManual` is equivalent to earlier `automaticallyShowsScopeBar == NO`
        /// Similar to the behavior of `automaticallyShowsScopeBar`, setting the `showsScopeBar` property on the `searchController`'s `searchBar`
        /// will change `scopeBarActivation` to `UISearchControllerScopeBarActivationManual`
        #[unsafe(method(scopeBarActivation))]
        #[unsafe(method_family = none)]
        pub fn scopeBarActivation(&self) -> UISearchControllerScopeBarActivation;

        /// Setter for [`scopeBarActivation`][Self::scopeBarActivation].
        #[unsafe(method(setScopeBarActivation:))]
        #[unsafe(method_family = none)]
        pub fn setScopeBarActivation(
            &self,
            scope_bar_activation: UISearchControllerScopeBarActivation,
        );

        #[cfg(feature = "UISearchSuggestion")]
        /// List of search hint objects to be displayed under keyboard on tvOS,
        /// as a menu under the search field when the search bar is placed inline on iOS 16,
        /// or as a list in front of the searchResultsController when the search bar is stacked.
        /// Assigning with new array immediately updates the list on screen.
        /// searchSuggestions is set to nil when user interaction selects a suggestion,
        /// or when the user otherwise interacts with search (e.g., typing in the search field, choosing a different search scope, canceling search)
        /// after dismissing the menu by tapping outside
        #[unsafe(method(searchSuggestions))]
        #[unsafe(method_family = none)]
        pub fn searchSuggestions(
            &self,
        ) -> Option<Retained<NSArray<ProtocolObject<dyn UISearchSuggestion>>>>;

        #[cfg(feature = "UISearchSuggestion")]
        /// Setter for [`searchSuggestions`][Self::searchSuggestions].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSearchSuggestions:))]
        #[unsafe(method_family = none)]
        pub fn setSearchSuggestions(
            &self,
            search_suggestions: Option<&NSArray<ProtocolObject<dyn UISearchSuggestion>>>,
        );

        /// Default NO. When YES, the UISearchController will not create its internal child view controller
        /// for presenting the list of search suggestions when the searchBarPlacement is stacked.
        /// This property is intended to be set at the time that the search controller is initialized.
        /// If set after that point, the internal view controller will not be destroyed, but its view will be hidden and remain so.
        #[unsafe(method(ignoresSearchSuggestionsForSearchBarPlacementStacked))]
        #[unsafe(method_family = none)]
        pub fn ignoresSearchSuggestionsForSearchBarPlacementStacked(&self) -> bool;

        /// Setter for [`ignoresSearchSuggestionsForSearchBarPlacementStacked`][Self::ignoresSearchSuggestionsForSearchBarPlacementStacked].
        #[unsafe(method(setIgnoresSearchSuggestionsForSearchBarPlacementStacked:))]
        #[unsafe(method_family = none)]
        pub fn setIgnoresSearchSuggestionsForSearchBarPlacementStacked(
            &self,
            ignores_search_suggestions_for_search_bar_placement_stacked: bool,
        );

        #[cfg(all(feature = "UIScrollView", feature = "UIView"))]
        #[deprecated = "Use -[UIViewController setContentScrollView:forEdge:] on the searchResultsController instead."]
        #[unsafe(method(searchControllerObservedScrollView))]
        #[unsafe(method_family = none)]
        pub fn searchControllerObservedScrollView(&self) -> Option<Retained<UIScrollView>>;

        #[cfg(all(feature = "UIScrollView", feature = "UIView"))]
        /// Setter for [`searchControllerObservedScrollView`][Self::searchControllerObservedScrollView].
        #[deprecated = "Use -[UIViewController setContentScrollView:forEdge:] on the searchResultsController instead."]
        #[unsafe(method(setSearchControllerObservedScrollView:))]
        #[unsafe(method_family = none)]
        pub fn setSearchControllerObservedScrollView(
            &self,
            search_controller_observed_scroll_view: Option<&UIScrollView>,
        );
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
impl UISearchController {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
