//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uisearchtab?language=objc)
    #[unsafe(super(UITab, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UITab")]
    pub struct UISearchTab;
);

#[cfg(feature = "UITab")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UISearchTab {}
);

#[cfg(feature = "UITab")]
impl UISearchTab {
    extern_methods!(
        /// Determines if the search tab should automatically activate the embedded search field when the tab becomes visible.
        ///
        /// When this property is set to `YES`, the search field will be activated when the tab is selected. Moreover, when search is cancelled,
        /// the previously selected tab in the tab bar will be restored and selected. The default value is `NO`.
        #[unsafe(method(automaticallyActivatesSearch))]
        #[unsafe(method_family = none)]
        pub fn automaticallyActivatesSearch(&self) -> bool;

        /// Setter for [`automaticallyActivatesSearch`][Self::automaticallyActivatesSearch].
        #[unsafe(method(setAutomaticallyActivatesSearch:))]
        #[unsafe(method_family = none)]
        pub fn setAutomaticallyActivatesSearch(&self, automatically_activates_search: bool);

        #[cfg(all(
            feature = "UIResponder",
            feature = "UIViewController",
            feature = "block2"
        ))]
        /// Creates a search tab with a system localized title and image.
        ///
        /// # Safety
        ///
        /// `view_controller_provider` block's return must be a valid pointer.
        #[unsafe(method(initWithViewControllerProvider:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithViewControllerProvider(
            this: Allocated<Self>,
            view_controller_provider: Option<
                &block2::DynBlock<dyn Fn(NonNull<UITab>) -> NonNull<UIViewController>>,
            >,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `UITab`.
#[cfg(feature = "UITab")]
impl UISearchTab {
    extern_methods!(
        #[cfg(all(
            feature = "UIImage",
            feature = "UIResponder",
            feature = "UIViewController",
            feature = "block2"
        ))]
        /// Creates a tab with the specified identifier, title, image, and view controller provider.
        /// The view controller provider is called when a view controller is requested and is currently nil.
        /// For root level tabs on `UITabBarController`, the resolved view controller must be non-nil.
        ///
        /// # Safety
        ///
        /// `view_controller_provider` block's return must be a valid pointer.
        #[unsafe(method(initWithTitle:image:identifier:viewControllerProvider:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithTitle_image_identifier_viewControllerProvider(
            this: Allocated<Self>,
            title: &NSString,
            image: Option<&UIImage>,
            identifier: &NSString,
            view_controller_provider: Option<
                &block2::DynBlock<dyn Fn(NonNull<UITab>) -> NonNull<UIViewController>>,
            >,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
