---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, couleur, 
              fond de paragraphe, surlignage
---

# Comment colorer le fond d'un paragraphe ?

## Avec l'extension <ctanpkg:xcolor>

L'extension <ctanpkg:xcolor> propose une commande `\colorbox` permettant 
de colorer le fond du texte qu'elle encadre :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{xcolor}

\begin{document}
Voici \colorbox[gray]{0.8}{un peu de gris !}

Voici \colorbox[gray]{0.8}{un peu de gris et encore un peu de gris 
et encore un peu de gris et encore un peu de gris 
et encore un peu de gris et encore un peu de gris 
et encore un peu de gris !}
\end{document}
```

La seconde phrase de l'exemple montre que la commande `\colorbox` compose 
son argument sur une seule ligne... À vos risques et périls.


## Avec l'extension <ctanpkg:soul>

Lorsque l'extension <ctanpkg:xcolor> a été chargée, il est possible d'utiliser
la commande `\hl` de l'extension <ctanpkg:soul> qui, elle, ne compose pas son
argument sur une seule ligne ! La commande `\sethlcolor` permet de définir la
couleur avec laquelle le texte sera surligné.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{xcolor,soul}

  \sethlcolor{green}

\begin{document}
Voici que ce texte \hl{est surligné en vert et encore un peu de vert 
et encore un peu de vert et encore un peu de vert et encore un peu de vert 
et encore un peu de vert et encore un peu de vert !}
\end{document}
```


## Avec l'extension <ctanpkg:tcolorbox>

Cette extension très puissante, basée sur <ctanpkg:tikz> a pour objet 
les boîtes colorées, ainsi que son nom l'indique. Parmi ses très nombreuses
fonctionnalités, elle peut colorer le fond des paragraphes.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tcolorbox}
  \usepackage{lipsum}

  \tcbset{
    colback=red!5!white,      % couleur de fond (5 % rouge, 95 % blanc)
    boxrule=0pt               % épaisseur du cadre nulle
  }

\begin{document}
\section{Texte normal}
\lipsum[1][1-4]
\section{Encadrement minimal}
\begin{tcolorbox}[size=minimal]
\lipsum[1][1-4]
\end{tcolorbox}
\section{Encadrement normal}
\begin{tcolorbox}
\lipsum[1][1-4]
\end{tcolorbox}
\section{Encadrement dépassant dans la marge}
\begin{tcolorbox}[oversize]
\lipsum[1][1-4]
\end{tcolorbox}
\end{document}
```


## Avec l'extension <ctanpkg:shadethm>

L'extension <ctanpkg:shadethm> défini l'environnement `shadebox` qui permet
de griser un ou plusieurs paragraphes, ceux-ci pouvant contenir les listes
et des formules mathématiques, comme l'illustre l'exemple ci-dessous :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{shadethm}

\begin{document}
Il est important de noter que
\begin{shadebox}
  \begin{equation}
    0+0 = 0
  \end{equation}
\end{shadebox}
n'est-ce pas ?
\end{document}
```


## Avec l'extension <ctanpkg:shadbox>

L'extension <ctanpkg:shadbox> permet de griser toute boîte, texte, figure...

:::{todo} Illustrer cette extension et les suivantes.
:::


## Avec l'extension <ctanpkg:shading>

L'extension <ctanpkg:shading> permet de griser un paragraphe.


## Avec l'extension <ctanpkg:shade>

L'extension <ctanpkg:shade> de Peter Schmitt définit une commande `\shade` 
permettant d'obtenir cet effet.


<!-- ## Avec l'extension <ctanpkg:psboxit> -->
<!--  -->
<!-- L'extension <ctanpkg:psboxit>, et en particulier l'environnement `boxitpara`, -->
<!-- permet d'obtenir du gris ou de la couleur par insertion de code Postcript. -->
<!--  -->
<!-- :::{todo} *Ajouter des exemples compilés sur cette extension et les suivantes.* -->
<!-- ::: -->


<!-- ## Avec l'extension myColor -->
<!--  -->
<!-- L'extension [myColor](https://texnik.dante.de/cgi-bin/mainFAQ.cgi?file=color/color#paragraph) (sur le site de Dante) utilise une minipage pour permettre de changer la couleur d'un ou plusieurs paragraphes. En voici le code fournissant la commande `\cminipage`. -->
<!--  -->
<!-- ``` -->
<!-- \RequirePackage{xcolor,calc} -->
<!-- \NeedsTeXFormat{LaTeX2e}[1995/12/01] -->
<!-- \ProvidesPackage{myColor} -->
<!--               [2000/10/26 v1.0 LaTeX package for colored paragraphs.] -->
<!-- \newcommand{\cmcolor}{} -->
<!-- \newenvironment{cminipage}[1][white]% -->
<!--   {%\setlength{\fboxsep}{-\fboxrule} -->
<!--    \renewcommand{\cmcolor}{#1}\noindent% -->
<!--    \begin{lrbox}{\@tempboxa}% -->
<!--      \begin{minipage}{\linewidth-2\fboxsep}}% -->
<!--   {  \end{minipage}% -->
<!--    \end{lrbox}% -->
<!--    \colorbox{\cmcolor}{\usebox{\@tempboxa}}}% -->
<!-- %% -->
<!-- %% -->
<!-- %% End of file `myColor.sty'. -->
<!-- ``` -->