/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.internal;

import com.jgoodies.components.internal.AbstractUnderlineSupport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

public final class MnemonicUnderlineSupport
extends AbstractUnderlineSupport {
    static final String PROPERTY_MNEMONIC_INDEX = "mnemomicIndex";
    private static final int NO_MNEMONIC_INDEX = -1;
    private static final MnemonicUnderlineSupport INSTANCE = new MnemonicUnderlineSupport();

    private MnemonicUnderlineSupport() {
    }

    public static int getMnemonicIndex(JTextComponent c) {
        Object index = c.getClientProperty(PROPERTY_MNEMONIC_INDEX);
        return index instanceof Integer ? (Integer)index : -1;
    }

    public static void setMnemonicIndex(JTextComponent c, int newValue) {
        int oldValue = MnemonicUnderlineSupport.getMnemonicIndex(c);
        if (oldValue == newValue) {
            return;
        }
        c.putClientProperty(PROPERTY_MNEMONIC_INDEX, newValue);
        INSTANCE.uninstall(c);
        if (newValue != -1) {
            INSTANCE.install(c);
        }
        c.repaint();
    }

    @Override
    protected void updateUnderline(JTextComponent c) {
        int length;
        Highlighter highlighter = c.getHighlighter();
        int index = MnemonicUnderlineSupport.getMnemonicIndex(c);
        if (index >= (length = c.getDocument().getLength())) {
            return;
        }
        Object tag = c.getClientProperty(this.keyUnderlinePainterTag);
        try {
            if (tag == null) {
                tag = highlighter.addHighlight(index, index + 1, this.createHighlightPainter());
                c.putClientProperty(this.keyUnderlinePainterTag, tag);
            } else {
                highlighter.changeHighlight(tag, index, index + 1);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    protected DefaultHighlighter.DefaultHighlightPainter createHighlightPainter() {
        return new MnemonicUnderlinePainter();
    }

    private static final class MnemonicUnderlinePainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        MnemonicUnderlinePainter() {
            super(null);
        }

        @Override
        public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
            try {
                Shape shape = c.getUI().getRootView(c).modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                MnemonicUnderlinePainter.paintUnderline(g, c, MnemonicUnderlinePainter.outline(MnemonicUnderlinePainter.bounds(shape)));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            Rectangle r = null;
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                r = MnemonicUnderlinePainter.bounds(bounds);
            } else {
                try {
                    Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    r = MnemonicUnderlinePainter.bounds(shape);
                }
                catch (BadLocationException shape) {
                    // empty catch block
                }
            }
            if (r != null) {
                Rectangle rect = MnemonicUnderlinePainter.outline(r);
                MnemonicUnderlinePainter.paintUnderline(g, c, rect);
                return rect;
            }
            return null;
        }

        private static void paintUnderline(Graphics g, JTextComponent c, Rectangle clip) {
            Color oldColor = g.getColor();
            Shape oldClip = g.getClip();
            g.setColor(c.getForeground());
            g.clipRect(clip.x, clip.y, clip.width, clip.height);
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            g.setClip(oldClip);
            g.setColor(oldColor);
        }

        private static Rectangle bounds(Shape shape) {
            return shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        }

        private static Rectangle outline(Rectangle r) {
            return new Rectangle(r.x, r.y + r.height - 1, r.width - 2, 1);
        }
    }
}

