/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.tiles;

import com.jgoodies.common.bean.Bean;
import com.jgoodies.fluent.tiles.Tile;
import java.awt.Point;
import java.util.function.Function;

public final class EmptyTile
extends Bean
implements Tile {
    private Point origin;
    private Tile.Size size;

    public EmptyTile() {
        this(Tile.Size.WIDE);
    }

    public EmptyTile(Tile.Size size) {
        this.setSize(size);
    }

    @Override
    public Point getOrigin() {
        return this.origin;
    }

    void setOrigin(Point origin) {
        this.origin = origin;
    }

    @Override
    public Tile.Size getSize() {
        return this.size;
    }

    private void setSize(Tile.Size size) {
        this.size = size;
    }

    static abstract class AbstractBuilder<B extends AbstractBuilder<?>> {
        protected final EmptyTile target = new EmptyTile();

        AbstractBuilder() {
        }

        public final B size(Tile.Size value) {
            this.target.setSize(value);
            return (B)this;
        }

        public final B small() {
            return this.size(Tile.Size.SMALL);
        }

        public final B medium() {
            return this.size(Tile.Size.MEDIUM);
        }

        public final B wide() {
            return this.size(Tile.Size.WIDE);
        }

        public final B large() {
            return this.size(Tile.Size.LARGE);
        }

        public final B origin(int x, int y) {
            this.target.setOrigin(new Point(x, y));
            return (B)this;
        }

        protected EmptyTile build() {
            return this.target;
        }
    }

    public static final class Adder<B>
    extends AbstractBuilder<Adder<B>> {
        private final Function<Tile, B> addFunction;

        public Adder(Function<Tile, B> addFunction) {
            this.addFunction = addFunction;
        }

        public B endEmptyTile() {
            return this.addFunction.apply(this.build());
        }
    }

    public static final class Builder
    extends AbstractBuilder<Builder> {
        @Override
        public EmptyTile build() {
            return super.build();
        }
    }
}

